# Differential Network Analysis (Panwar et al 2021)

library(MASS)	# standard, no need to install
library(class)	# standard, no need to install
library(cluster)
library(WGCNA)
library(impute)# install it for imputing missing value
library(scatterplot3d)
setwd("/Users/bpanwar/Desktop/SLE/WGCNA/firstvisit/DNA")
# The following setting is important, do not omit.
options(stringsAsFactors = FALSE);

# 1. Data input
dat0=read.csv("FirstVisitExpressionProfiles.csv",header=T)
names(dat0)
datSummary0=dat0[,c(1:2)]
dim(dat0)
dat0[1:5,1:5]
datExpr0 <- t(dat0[,3:90])
datExpr0[1:5,1:5]
dim(datExpr0)
no.samples <- dim(datExpr0)[[1]]
no.samples
dimnames(datExpr0)[[2]]=datSummary0[,1]
dim(datExpr0)
datExpr0[1:5,1:5]
gsg = goodSamplesGenes(datExpr0, verbose = 3);
if (!gsg$allOK){ if (sum(!gsg$goodGenes)>0) printFlush(paste("Removing genes:", paste(names(datExpr0)[!gsg$goodGenes], collapse = ", "))); if (sum(!gsg$goodSamples)>0) printFlush(paste("Removing samples:", paste(rownames(datExpr0)[!gsg$goodSamples], collapse = ", "))); datExpr0 = datExpr0[gsg$goodSamples, gsg$goodGenes] }
sampleTree = hclust(dist(datExpr0), method = "average");
# Plot the sample tree: Open a graphic output window of size 12 by 9 inches
# The user should change the dimensions if the window is too large or too small.
sizeGrWindow(12,9)
pdf(file = "sampleClustering.pdf", width = 12, height = 9);
par(cex = 0.6);
par(mar = c(0,4,2,0))
plot(sampleTree, main = "Sample clustering to detect outliers", sub="", xlab="", cex.lab = 1.5,
cex.axis = 1.5, cex.main = 2)
# Plot a line to show the cut
#abline(h = 50000, col = "red");
dev.off()
# Determine cluster under the line
# clust = cutreeStatic(sampleTree, cutHeight = 50000, minSize = 10)
# table(clust)
# clust 1 contains the samples we want to keep.
# keepSamples = (clust==1)
# datExpr = datExpr0[keepSamples, ]
# nGenes = ncol(datExpr)
# nSamples = nrow(datExpr)
datExpr = datExpr0
nGenes = ncol(datExpr)
nSamples = nrow(datExpr)
datClinicalTraits=read.csv("FirstVisitClinicalTraits.csv",header=T)
datClinicalTraits[1:5,1:5]
restrictPatientID=is.element(datClinicalTraits$PatientID,dimnames(datExpr)[[1]])
table(restrictPatientID)
datClinicalTraits=datClinicalTraits[restrictPatientID,]
orderTraits=order(datClinicalTraits$PatientID)
orderExpr=order(dimnames(datExpr)[[1]])
datClinicalTraits =datClinicalTraits[orderTraits,]
datExpr =datExpr[orderExpr,]
table(datClinicalTraits$PatientID==dimnames(datExpr)[[1]])
rm(dat0);
collectGarbage()
datClinicalTraits[1:5,1:5]
datClinicalTraits$IFN
IFN=as.numeric(datClinicalTraits$IFN)
IFN
rest1=rank(-IFN,ties="first")<=30
rest2=rank(IFN,ties="first")<=34
rest1
rest2
table(rest1)
table(rest2)
table(rest1==T & rest2==T)
datExpr1=datExpr[rest1,]
datExpr2=datExpr[rest2,]
datExpr1[1:5,1:5]
datExpr2[1:5,1:5]
names(datClinicalTraits)
allTraits = datClinicalTraits[, c(1,5,6,10,11,12,13,14,16,22,47,48,49,50,51,52)];
allTraits[1:5,1:5]
dim(allTraits)
names(allTraits)
sample1 = rownames(datExpr1);
traitRows1 = match(sample1, allTraits$PatientID);
traitRows1
datTraits1 = allTraits[traitRows1, -1];
datTraits1
rownames(datTraits1) = allTraits[traitRows1, 1];
datTraits1
collectGarbage()
sample2 = rownames(datExpr2)
traitRows2 = match(sample2, allTraits$PatientID)
traitRows2
datTraits2 = allTraits[traitRows2, -1]
datTraits2
rownames(datTraits2) = allTraits[traitRows2, 1];
datTraits2
collectGarbage()
sampleTree1 = hclust(dist(datExpr1), method = "average")
traitColors1 = numbers2colors(datTraits1, signed = FALSE);
pdf(file = "sampleClusteringIFNpos.pdf", width = 16, height = 12);
par(cex = 0.6);
par(mar = c(4,6,2,2))
plotDendroAndColors(sampleTree1, traitColors1,groupLabels = names(datTraits1),main = "IFNpos: Sample dendrogram and trait heatmap")
dev.off()
save(datExpr1, datTraits1, file = "IFNpos-WGCNA-01-dataInput.RData")
sampleTree2 = hclust(dist(datExpr2), method = "average")
traitColors2 = numbers2colors(datTraits2, signed = FALSE);
pdf(file = "sampleClusteringIFNneg.pdf", width = 16, height = 12);
par(cex = 0.6);
par(mar = c(4,6,2,2))
plotDendroAndColors(sampleTree2, traitColors2, groupLabels = names(datTraits2),main = "IFNneg: Sample dendrogram and trait heatmap")
dev.off()
save(datExpr2, datTraits2, file = "IFNneg-WGCNA-01-dataInput.RData")

# 2. Network construction and module detection
lnames = load(file = "IFNpos-WGCNA-01-dataInput.RData");
lnames
powers = c(c(1:10), seq(from = 12, to=20, by=2))
sft = pickSoftThreshold(datExpr1, powerVector = powers, verbose = 5)
sizeGrWindow(9, 5)
par(mfrow = c(1,2));
cex1 = 0.9;
plot(sft$fitIndices[,1], -sign(sft$fitIndices[,3])*sft$fitIndices[,2],xlab="Soft Threshold (power)",ylab="Scale Free Topology Model Fit,signed R^2",type="n",main = paste("Scale independence"));
text(sft$fitIndices[,1], -sign(sft$fitIndices[,3])*sft$fitIndices[,2],labels=powers,cex=cex1,col="red");
abline(h=0.90,col="red")
plot(sft$fitIndices[,1], sft$fitIndices[,5],xlab="Soft Threshold (power)",ylab="Mean Connectivity", type="n",main = paste("Mean connectivity"))
text(sft$fitIndices[,1], sft$fitIndices[,5], labels=powers, cex=cex1,col="red")
net1 = blockwiseModules(datExpr1, checkMissingData = TRUE, power = 6,TOMType = "unsigned", minModuleSize = 30, maxBlockSize = 16444, reassignThreshold = 0, mergeCutHeight = 0.25, numericLabels = TRUE, pamRespectsDendro = FALSE,saveTOMs = TRUE, saveTOMFileBase = "IFNposTOM", verbose = 3)
sizeGrWindow(15, 15)
table(net1$colors)
mergedColors1 = labels2colors(net1$colors)
plotDendroAndColors(net1$dendrograms[[1]], mergedColors1[net1$blockGenes[[1]]],"Module colors",dendroLabels = FALSE, hang = 0.03,addGuide = TRUE, guideHang = 0.05, main = "IFNpos: Gene dendrogram and module colors")
moduleLabels1 = net1$colors
moduleColors1 = labels2colors(net1$colors)
posMEs = net1$MEs;
geneTree1 = net1$dendrograms[[1]];
save(posMEs, moduleLabels1, moduleColors1, geneTree1, file = "IFNpos-02-networkConstruction-auto.RData")
lnames = load(file = "IFNneg-WGCNA-01-dataInput.RData");
lnames
powers = c(c(1:10), seq(from = 12, to=20, by=2))
sft = pickSoftThreshold(datExpr2, powerVector = powers, verbose = 5)
sizeGrWindow(9, 5)
par(mfrow = c(1,2));
cex1 = 0.9;
plot(sft$fitIndices[,1], -sign(sft$fitIndices[,3])*sft$fitIndices[,2],xlab="Soft Threshold (power)",ylab="Scale Free Topology Model Fit,signed R^2",type="n",main = paste("Scale independence"));
text(sft$fitIndices[,1], -sign(sft$fitIndices[,3])*sft$fitIndices[,2],labels=powers,cex=cex1,col="red");
abline(h=0.90,col="red")
plot(sft$fitIndices[,1], sft$fitIndices[,5],xlab="Soft Threshold (power)",ylab="Mean Connectivity", type="n",main = paste("Mean connectivity"))
text(sft$fitIndices[,1], sft$fitIndices[,5], labels=powers, cex=cex1,col="red")
net2 = blockwiseModules(datExpr2, checkMissingData = TRUE, power = 6,TOMType = "unsigned", minModuleSize = 30, maxBlockSize = 16444, reassignThreshold = 0, mergeCutHeight = 0.25, numericLabels = TRUE, pamRespectsDendro = FALSE,saveTOMs = TRUE, saveTOMFileBase = "IFNnegTOM", verbose = 3)
sizeGrWindow(15, 15)
table(net2$colors)
mergedColors2 = labels2colors(net2$colors)
plotDendroAndColors(net2$dendrograms[[1]], mergedColors2[net2$blockGenes[[1]]],"Module colors",dendroLabels = FALSE, hang = 0.03,addGuide = TRUE, guideHang = 0.05, main = "IFNneg: Gene dendrogram and module colors")
moduleLabels2 = net2$colors
moduleColors2 = labels2colors(net2$colors)
negMEs = net2$MEs;
geneTree2 = net2$dendrograms[[1]];
save(negMEs, moduleLabels2, moduleColors2, geneTree2, file = "IFNneg-02-networkConstruction-auto.RData")
table(moduleColors1)
table(moduleColors2)

# 3. Relating modules to external clinical traits and identifying important genes
lnames = load(file = "IFNpos-WGCNA-01-dataInput.RData");
lnames
lnames = load(file = "IFNpos-02-networkConstruction-auto.RData");
lnames
nGenes1 = ncol(datExpr1);
nSamples1 = nrow(datExpr1);
MEs01 = moduleEigengenes(datExpr1, moduleColors1)$eigengenes
MEs1 = orderMEs(MEs01)
row.names(MEs1) = row.names(datExpr1)
write.csv(MEs1, file = "MEs1.csv", row.names = TRUE)
moduleTraitCor1 = cor(MEs1, datTraits1, use = "p");
moduleTraitPvalue1 = corPvalueStudent(moduleTraitCor1, nSamples1);
sizeGrWindow(20,20)
textMatrix1 =  paste(signif(moduleTraitCor1, 2), "\n(",signif(moduleTraitPvalue1, 1), ")", sep = "");
textMatrix1
dim(textMatrix1) = dim(moduleTraitCor1)
par(mar = c(6.5, 12, 1, 3));
labeledHeatmap(Matrix = moduleTraitCor1,xLabels = names(datTraits1),yLabels = names(MEs1),ySymbols = names(MEs1),colorLabels = FALSE,colors = redWhiteGreen(50),textMatrix = textMatrix1,setStdMargins = FALSE,cex.text = 0.4,zlim = c(-1,1),main = paste("cMo-IFNpos-TPM1: Module-trait relationships"))
write.csv(moduleTraitCor1, file = "moduleTraitsTableIFNpos.csv", row.names = TRUE)
write.csv(moduleTraitPvalue1, file = "moduleTraitsPvalueTableIFNpos.csv", row.names = TRUE)
lnames = load(file = "IFNneg-WGCNA-01-dataInput.RData");
lnames
lnames = load(file = "IFNneg-02-networkConstruction-auto.RData");
lnames
nGenes2 = ncol(datExpr2);
nSamples2 = nrow(datExpr2);
nMEs0 = moduleEigengenes(datExpr2, moduleColors2)$eigengenes
MEs2 = orderMEs(nMEs0)
row.names(MEs2) = row.names(datExpr2)
write.csv(MEs2, file = "MEs2.csv", row.names = TRUE)
moduleTraitCor2 = cor(MEs2, datTraits2, use = "p");
moduleTraitPvalue2 = corPvalueStudent(moduleTraitCor2, nSamples2);
sizeGrWindow(20,20)
textMatrix2 =  paste(signif(moduleTraitCor2, 2), "\n(",signif(moduleTraitPvalue2, 1), ")", sep = "");
textMatrix2
dim(textMatrix2) = dim(moduleTraitCor2)
par(mar = c(6.5, 12, 1, 3));
labeledHeatmap(Matrix = moduleTraitCor2,xLabels = names(datTraits2),yLabels = names(MEs2),ySymbols = names(MEs2),colorLabels = FALSE,colors = redWhiteGreen(50),textMatrix = textMatrix2,setStdMargins = FALSE,cex.text = 0.4,zlim = c(-1,1),main = paste("cMo-IFNneg-TPM1: Module-trait relationships"))
write.csv(moduleTraitCor2, file = "moduleTraitsTableIFNneg.csv", row.names = TRUE)
write.csv(moduleTraitPvalue2, file = "moduleTraitsPvalueTableIFNneg.csv", row.names = TRUE)

# 4. Overlap modules between IFNpos vs IFNneg
lnames = load(file = "IFNpos-WGCNA-01-dataInput.RData");
lnames
lnames = load(file = "IFNpos-02-networkConstruction-auto.RData");
lnames
MEs01 = moduleEigengenes(datExpr1, moduleColors1)$eigengenes
MEs1 = orderMEs(MEs01)
posLabels = moduleLabels1;
posColors = moduleColors1;
posTree = geneTree1;
lnames = load(file = "IFNneg-WGCNA-01-dataInput.RData");
lnames
lnames = load(file = "IFNneg-02-networkConstruction-auto.RData");
lnames
nMEs0 = moduleEigengenes(datExpr2, moduleColors2)$eigengenes
MEs2 = orderMEs(nMEs0)
negLabels = moduleLabels2;
negColors = moduleColors2;
negTree = geneTree2;
MEs1
MEs2
posModules = substring(names(MEs1), 3)
posModules
negModules = substring(names(MEs2), 3)
negModules
nPosMods = length(posModules)
nNegMods = length(negModules)
nPosMods
nNegMods
pTable = matrix(0, nrow = nPosMods, ncol = nNegMods);
CountTbl = matrix(0, nrow = nPosMods, ncol = nNegMods);
pTable
CountTbl
# Execute all pairwaise comparisons
for (pmod in 1:nPosMods)
for (nmod in 1:nNegMods)
{
posMembers = (posColors == posModules[pmod]);
negMembers = (negColors == negModules[nmod]);
pTable[pmod, nmod] = -log10(fisher.test(posMembers, negMembers, alternative = "greater")$p.value);
CountTbl[pmod, nmod] = sum(posColors == posModules[pmod] & negColors == negModules[nmod])
}
# Truncate p values smaller than 10^{-50} to 10^{-50}
pTable[is.infinite(pTable)] = 1.3*max(pTable[is.finite(pTable)]);
pTable[pTable>50 ] = 50 ;
CountTbl
# Marginal counts (really module sizes)
posModTotals = apply(CountTbl, 1, sum)
negModTotals = apply(CountTbl, 2, sum)
posModTotals
negModTotals
table(posColors)
table(negColors)
# Actual plotting
sizeGrWindow(10,7 );
pdf(file = "Consensus.pdf", wi = 10, he = 7);
par(mfrow=c(1,1));
par(cex = 1.0);
par(mar=c(8, 10.4, 2.7, 1)+0.3);
# Use function labeledHeatmap to produce the color-coded table with all the trimmings
labeledHeatmap(Matrix = pTable,
xLabels = paste(" ", negModules),
yLabels = paste(" ", posModules),
colorLabels = TRUE,
xSymbols = paste("IFNneg ", negModules, ": ", negModTotals, sep=""),
ySymbols = paste("IFNpos ", posModules, ": ", posModTotals, sep=""),
textMatrix = CountTbl,
colors = greenWhiteRed(100)[50:100],
main = "Correspondence of IFNpos and IFNneg modules",
cex.text = 0.6, cex.lab = 0.75, setStdMargins = FALSE);
dev.off()

# Differential Network Analysis (DNA)
k1=softConnectivity(datExpr1, power=6)
k2=softConnectivity(datExpr2, power=6)
K1=k1/max(k1)
K2=k2/max(k2)
DiffK=K1-K2
head(k1)
head(k2)
head(K1)
head(K2)
poolRest=as.logical(rest1+rest2)
poolRest
factorLevels=rep(NA,length(poolRest))
factorLevels[rest1]="IFNpos" # trait 1 is IFNpos
factorLevels[rest2]="IFNneg" # trait 2 is IFNneg
factorLevels[rest1]
factorLevels[rest2]
ttest=rep(NA, dim(datExpr)[[2]])
ttest
dim(datExpr)[[2]]
for (i in 1:dim(datExpr)[[2]]){
ttest[i]=t.test(datExpr[poolRest,i]~factorLevels[poolRest])$statistic
}
ttest
poolRest
dim(datExpr1)
temp1=sample(which(poolRest==T),30,replace=F)
temp1
Rest1=rep(F,length(poolRest))
Rest1
Rest1[temp1]=T
table(Rest1)
Rest2=as.logical(poolRest-Rest1)
table(Rest2)
table(Rest1==T & Rest2==T)
factorLevels2=rep(NA,length(poolRest))
factorLevels2[Rest1]="permIFNpos"
factorLevels2[Rest2]="permIFNneg"
datExpr1.2=datExpr[Rest1,]
datExpr2.2=datExpr[Rest2,]
k1.2=softConnectivity(datExpr1.2, power=6)
k2.2=softConnectivity(datExpr2.2, power=6)
K1.2=k1.2/max(k1.2)
K2.2=k2.2/max(k2.2)
DiffK.2=K1.2-K2.2
ttest2=rep(NA, dim(datExpr)[[2]])
# Let's determine the t-statistic.
for (i in 1:dim(datExpr)[[2]]){
ttest2[i]=t.test(datExpr[poolRest,i]~factorLevels2[poolRest])$statistic
}

# Plotting DiffK versus ttest in Unpermuted and Permuted
par(mfrow=c(1,2))
plot(DiffK,ttest, main=paste("Unpermuted: cor=", signif(cor(DiffK,ttest, use="pairwise.complete.obs") ,3)),xlim=range(DiffK),ylim=range(ttest)) # colorGroup1 ??
abline(h=1.96)
abline(h=-1.96)
abline(v=.4)
abline(v=-.4)
plot(DiffK.2,ttest2, main=paste("Permuted: cor=", signif(cor(DiffK.2,ttest2, use="pairwise.complete.obs") ,3)), xlim=range(DiffK),ylim=range(ttest))
# colorGroup1 ??
abline(h=1.96)
abline(h=-1.96)
abline(v=.4)
abline(v=-.4)
# Here are the sector counts for unpermuted:
sector1obs = (ttest>1.96) & (DiffK<(-0.4))
n1obs=sum(sector1obs)
sector2obs = (ttest>1.96) &(DiffK>(-0.4)) & (DiffK<0.4)
n2obs=sum(sector2obs)
sector3obs = (ttest>1.96) & (DiffK>0.4)
n3obs=sum(sector3obs)
sector4obs = (ttest>(-1.96)) & (ttest<1.96) & (DiffK>0.4)
n4obs=sum(sector4obs)
sector5obs = (ttest<(-1.96)) & (DiffK>0.4)
n5obs=sum(sector5obs)
sector6obs = (ttest<(-1.96)) &(DiffK>(-0.4)) & (DiffK<0.4)
n6obs=sum(sector6obs)
sector7obs = (ttest<(-1.96)) & (DiffK<(-0.4))
n7obs=sum(sector7obs)
sector8obs = (ttest>(-1.96)) & (ttest<1.96) & (DiffK<(-0.4))
n8obs=sum(sector8obs)
no.perms=100
n1perm=rep(NA,no.perms)
n2perm=rep(NA,no.perms)
n3perm=rep(NA,no.perms)
n4perm=rep(NA,no.perms)
n5perm=rep(NA,no.perms)
n6perm=rep(NA,no.perms)
n7perm=rep(NA,no.perms)
n8perm=rep(NA,no.perms)
for (i in c(1:no.perms)) {
temp1=sample(which(poolRest==T),30,replace=F)
Rest1=rep(F,length(poolRest))
Rest1[temp1]=T
Rest2=as.logical(poolRest-Rest1)
factorLevels2=rep(NA,length(poolRest))
factorLevels2[Rest1]="fakeIFNpos"
factorLevels2[Rest2]="fakeIFNneg"
datExprIFNpos.2=datExpr[Rest1,]
datExprIFNneg.2=datExpr[Rest2,]
k1.2=softConnectivity(datExprIFNpos.2, power=6)
k2.2=softConnectivity(datExprIFNneg.2, power=6)
K1.2=k1.2/max(k1.2)
K2.2=k2.2/max(k2.2)
DiffK.2=K1.2-K2.2
ttest2=rep(NA, dim(datExpr)[[2]])

# Let's determine the t-statistic.
for (j in 1:dim(datExpr)[[2]]){
ttest2[j]=t.test(datExpr[poolRest,j]~factorLevels2[poolRest])$statistic
}
sector1perm = (ttest2>1.96) & (DiffK.2<(-0.4))
n1perm[i]=sum(sector1perm)
sector2perm = (ttest2>1.96) &(DiffK.2>(-0.4)) & (DiffK.2<0.4)
n2perm[i]=sum(sector2perm)
sector3perm = (ttest2>1.96) & (DiffK.2>0.4)
n3perm[i]=sum(sector3perm)
sector4perm = (ttest2>(-1.96)) & (ttest2<1.96) & (DiffK.2>0.4)
n4perm[i]=sum(sector4perm)
sector5perm = (ttest2<(-1.96)) & (DiffK.2>0.4)
n5perm[i]=sum(sector5perm)
sector6perm = (ttest2<(-1.96)) &(DiffK.2>(-0.4)) & (DiffK.2<0.4)
n6perm[i]=sum(sector6perm)
sector7perm = (ttest2<(-1.96)) & (DiffK.2<(-0.4))
n7perm[i]=sum(sector7perm)
sector8perm = (ttest2>(-1.96)) & (ttest2<1.96) & (DiffK.2<(-0.4))
n8perm[i]=sum(sector8perm)
}
logicalSum1=sum(n1obs<=n1perm)
logicalSum2=sum(n2obs<=n2perm)
logicalSum3=sum(n3obs<=n3perm)
logicalSum4=sum(n4obs<=n4perm)
logicalSum5=sum(n5obs<=n5perm)
logicalSum6=sum(n6obs<=n6perm)
logicalSum7=sum(n7obs<=n7perm)
logicalSum8=sum(n8obs<=n8perm)
pval1=(logicalSum1+1)/(no.perms+1)
pval1
pval2=(logicalSum2+1)/(no.perms+1)
pval2
pval3=(logicalSum3+1)/(no.perms+1)
pval3
pval4=(logicalSum4+1)/(no.perms+1)
pval4
pval5=(logicalSum5+1)/(no.perms+1)
pval5
pval6=(logicalSum6+1)/(no.perms+1)
pval6
pval7=(logicalSum7+1)/(no.perms+1)
pval7
pval8=(logicalSum8+1)/(no.perms+1)
pval8
plotDendroAndColors(negTree, posColors, "Module colors",dendroLabels = FALSE, hang = 0.03,addGuide = TRUE, guideHang = 0.05,,main = "IFNneg: module color by IFNpos")
pdf(file = "IFNnegClusterDendrogramColorByIFNpos.pdf", width = 16, height = 12);
par(cex = 0.6);
par(mar = c(4,6,2,2))
plotDendroAndColors(negTree, posColors, "Module colors",dendroLabels = FALSE, hang = 0.03,addGuide = TRUE, guideHang = 0.05,,main = "IFNneg: module color by IFNpos")
dev.off()

# We look at DiffK versus ttest in different modules.
par(mfrow=c(1,2))
plot(DiffK,ttest,col=as.character(posColors),main="Colored by Network 1 (IFNpos)")
plot(DiffK,ttest,col=as.character(negColors),main="Colored by Network 2 (IFNneg)")
# Here we create a Network 1 plot that is colored by module definitions, with sectors
# delineated.
par(mfrow=c(1,1))
plot(DiffK,ttest,col=as.character(posColors),main=paste("Colored by Network 1 (IFNpos) Modules, cor=", signif(cor(DiffK,ttest,use="pairwise.complete.obs"),3)), xlim=range(DiffK),ylim=range(ttest),xlab="Difference in Connectivity",ylab="t-test statistic")
abline(h=1.96)
abline(h=-1.96)
abline(v=.4)
abline(v=-.4)
text(c(-0.5,-0.2,0.7,0.7,0.7,-0.2,-0.5,-0.5),c(7,7,7,0,-9,-9,-9,0),labels=c("1","2","3","4","5","6","7","8"),cex=3)
table(posColors)
geneInfo0 = data.frame(datSummary0,posColors, negColors, K1, K2, DiffK, ttest)
write.table(geneInfo0, "Summary_file.txt", sep="\t", quote = F)
write.csv(geneInfo0, file="Summary_file.csv", quote = FALSE, row.names = TRUE)
savehistory("SLE07242017.Rhistory")
pdf(file = "IFNposClusterDendrogramColorByIFNneg.pdf", width = 16, height = 12);
par(cex = 0.6);
par(mar = c(4,6,2,2))
plotDendroAndColors(posTree, negColors, "Module colors",dendroLabels = FALSE, hang = 0.03,addGuide = TRUE, guideHang = 0.05,,main = "IFNpos: module color by IFNneg")
dev.off()

## DiffK-vs-DEseq2
#
diffk_deseq <- read.csv("DiffK_DEseq.csv", row.names=2, stringsAsFactors=F, check.names=F)
plot(diffk_deseq$DiffK,fold_change,col=as.character(diffk_deseq$posColors),main=paste("Colored by Network 1 (IFNpos) Modules, cor=", signif(cor(diffk_deseq$DiffK,fold_change,use="pairwise.complete.obs"),3)), xlim=range(diffk_deseq$DiffK), xlab="Difference in Connectivity",ylab="FoldChange")
head(diffk_deseq)
names(diffk_deseq)
plot(diffk_deseq$DiffK,diffk_deseq$log2FoldChange,col=as.character(diffk_deseq$posColors),main=paste("Colored by Network 1 (IFNpos) Modules, cor=", signif(cor(diffk_deseq$DiffK,diffk_deseq$log2FoldChange,use="pairwise.complete.obs"),3)), xlim=range(diffk_deseq$DiffK), xlab="Difference in Connectivity",ylab="DESeq2: log2FoldChange")
abline(h=0.585)
abline(h=-0.585)
abline(v=.25)
abline(v=-.25)
plot(diffk_deseq$DiffK,diffk_deseq$padj,col=as.character(diffk_deseq$posColors), main=paste("Colored by Network 1 (IFNpos) Modules, cor=", signif(cor(diffk_deseq$DiffK,diffk_deseq$padj,use="pairwise.complete.obs"),3)), log ="y", xlim=range(diffk_deseq$DiffK), xlab="Difference in Connectivity",ylab="DESeq2: log2Padj")
log(0.05,2)
abline(h=-4.321928)
abline(v=.25)
abline(v=-.25)

diffk_deseq_gg <- read.csv("DiffK_DEseq_grey_green.csv", row.names=2, stringsAsFactors=F, check.names=F)
head(diffk_deseq_gg)
plot(diffk_deseq_gg$DiffK,diffk_deseq_gg$log2FoldChange,col=as.character(diffk_deseq_gg$posColors),main=paste("Grey-vs-Green: Colored by Network 1 (IFNpos) Modules, cor=", signif(cor(diffk_deseq_gg$DiffK,diffk_deseq_gg$log2FoldChange,use="pairwise.complete.obs"),3)), xlim=range(diffk_deseq_gg$DiffK), xlab="Difference in Connectivity",ylab="DESeq2: log2FoldChange")
abline(h=0.585)
abline(h=-0.585)
abline(v=.25)
abline(v=-.25)
plot(diffk_deseq_gg$DiffK,diffk_deseq_gg$padj,col=as.character(diffk_deseq_gg$posColors), main=paste("Grey-vs-Green: Colored by Network 1 (IFNpos) Modules, cor=", signif(cor(diffk_deseq_gg$DiffK,diffk_deseq_gg$padj,use="pairwise.complete.obs"),3)), log ="y", xlim=range(diffk_deseq_gg$DiffK), xlab="Difference in Connectivity",ylab="DESeq2: log2Padj")
abline(h=-4.321928)
abline(v=.25)
abline(v=-.25)
plot(diffk_deseq_gg$DiffK,diffk_deseq_gg$padj,col=as.character(diffk_deseq_gg$negColors), main=paste("Grey-vs-Green: Colored by Network 1 (IFNpos) Modules, cor=", signif(cor(diffk_deseq_gg$DiffK,diffk_deseq_gg$padj,use="pairwise.complete.obs"),3)), log ="y", xlim=range(diffk_deseq_gg$DiffK), xlab="Difference in Connectivity",ylab="DESeq2: log2Padj")


savehistory("DifferentialNetworkAnalysis.Rhistory")
