% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_effects_vector_inspection.R
\name{batch_effects_vector_inspection}
\alias{batch_effects_vector_inspection}
\title{batch_effects_vector_inspection}
\usage{
batch_effects_vector_inspection(
  object,
  quantile = 0.95,
  PCs_to_check,
  clusters_to_check
)
}
\arguments{
\item{object}{A dmatch class object}

\item{quantile}{The minimum number of the data points regarded as good points}

\item{PCs_to_check}{Which PCs to check, for example, if set to be 1:10, this function will check the batch effects angles in every 2D PC space (PC1 and 2, PC3 and 4, ..., PC9 and 10)}

\item{clusters_to_check}{Check the angles between which clusters, more specifically, the candidate clusters for anchors. For example, if set to be list(c(1,2),c(2,3)), this function will check the angles between batch effects for cluster 1 and 2, and those for cluster 2 and 3, in the specified PC space}
}
\value{
A dmatch class object which have slots storing raw.data, batch.id, PCA, and more information. Specifically, batch_effects_vector_angles slot stores information for the angles between batch effects vectors for different anchor cluster
}
\description{
Function for calculating batch effects vectors and their angles, which can aid determining the right amount of PCs to correct for batch effects.
Batch effects vectors should be understood in the following way. When we correct batch effects for a pair of samples in 2-D PC space (PC1 and 2, PC3 and 4, ...), assume there are four shared clusters (1,2,3,4) in each of those two samples. We can draw a line (with direction) connecting the center of cluster 1 in the reference sample and the center of cluster 1 in the to-be-corrected sample. Direction of the line can be understood in the following way: positive means that the center of cluster 1 in the to-be-corrected reference sample is to the right of the center of cluster 1 in the reference sample; negative means the other way. Such lines are batch effects vectors. 
This function calculates the angles between those batch effects vectors. If the angles are small, for example, if the angle between batch effect vector for cluster 1 and that for cluster 2 is small, it means that the adjustments/correction for cluster 1 and cluster 2 are fairly similar. On the other hand, if the angle between batch effect vector for cluster 1 and that for cluster 2 is big, for example, almost 180 degrees, then whatever the adjustment/correction required for cluster 1 will be opposite to whatever adjustment/correction required for cluster 2. So the corrections required for different clusters are quite different.
Often, the default number of PCs (top 30 PCs) works well for batch effects correction. However, we can use this function to make sure that whether the angles between different batch effects vectors are overall acceptable (small or moderate sizes). Sometimes the batch effects are consistent only for top 6 PCs for example. Then we will correct batch effects on top 6 PCs.
}
\author{
Mengjie Chen, Qi Zhan
}
