#!/usr/bin/env Rscript
args<-commandArgs(TRUE)
out<-args[1]
out.submmit<-args[2]
bp<-as.numeric(args[3])

cat("\n")
cat("****************************************************","\n")
cat("Reading files from stdin","\n")
cat("****************************************************","\n")
cat("\n")

df <- read.table(file("stdin"), header=F, fill=T, sep="\t")
#df$idx<-paste(df[,1],df[,2],df[,3],sep="_")
#df$V9<-as.numeric(as.character(df$V9))
#df$V7<-as.numeric(as.character(df$V7))
df$idx<-paste(df[,1],df[,2],df[,3],sep="_")
df[,c(2,3,6,7,9)]<-apply(df[,c(2,3,6,7,9)],2,function(x)as.numeric(as.character(x)))


cat("\n")
cat("****************************************************","\n")
cat("Selecting a peak with highest enrichment among repliates","\n")
cat("****************************************************","\n")
cat("\n")

dff<-aggregate(V9 ~ idx, data = df, max) #gives original.names
median_mat<-merge(dff,df)
median_mat.ver1<-median_mat[,c("V1","V2","V3","V5","V6","V7","V7","V9","V10")]
colnames(median_mat.ver1)<-c("chr","start.rep","end.rep","chr","start.submmit","end.submmit","submmit","enrichment","idx")
write.table(median_mat.ver1,file=sprintf("%s.matrix.txt",out),quote=F,sep="\t",col.names=T,row.names=F)


#clist<-unique(df$idx)
#pbb <- txtProgressBar(min = 0, max = length(clist), style = 3)

#for(i in clist){
  #Sys.sleep(0.1)
   # update progress bar
  # setTxtProgressBar(pbb, i)

#dff<-df[df$idx %in% i,]
#med<-df[row.names(dff)[which(max(dff$V9) == dff$V9)],]
#if(i==clist[1]){
#	median_mat<-med
#}else{
#	  median_mat<-rbind(median_mat,med)
#}
#}

#write.table(median_mat,file=sprintf("%s.matrix.txt",out),quote=F,sep="\t",col.names=F,row.names=F)

cat("\n")
cat("****************************************************","\n")
cat("Writing outputs","\n")
cat("Regular peaks from chr1-chrX are saved",out,"\n")
cat("Submmits in  peaks from chr1-chrX are saved",out.submmit,"\n")
cat("****************************************************","\n")

## generate bed files

#median_mat$idx<-paste(median_mat$V1,median_mat$V2,median_mat$V3,sep="." )

write.table(median_mat.ver1[,c("chr","start.rep","end.rep","idx","submmit","enrichment")],file=out,sep="\t",quote=F,col.names=F,row.names=F)


### generate submmit regions +- 50bp (default)
median_mat.submmit<-median_mat.ver1[,c("chr","submmit","submmit","idx",,"enrichment")]
median_mat.submmit[,2]<-median_mat.submmit[,2]-(bp-1)
median_mat.submmit[,3]<-median_mat.submmit[,3]+bp
write.table(median_mat.submmit,file=out.submmit,sep="\t",quote=F,col.names=F,row.names=F)

