#!/usr/bin/env python
import numpy as np
import pandas as pd
from sys import argv

df = argv[1]
out = argv[2]

# df = "num_differential.in.enhancers.up_novel.cumulative.txt"
# out =  "num_differential.in.enhancers.up_novel.cumulative.scaled_to_1.txt"

# df = "num_differential.in.enhancers.down_novel.cumulative.txt"
# out =  "num_differential.in.enhancers.down_novel.cumulative.scaled_to_1.txt"

df = pd.read_csv(df, index_col=0, sep="\t")

# scale
arr_scaled = np.array(df) / np.vstack(df.max(axis=1)).astype('float')
arr_scaled[np.isnan(arr_scaled)] = 0
df_scaled = pd.DataFrame(arr_scaled, index=df.index, columns=df.columns)

df_scaled.to_csv(out, sep="\t", index=True)
