#!/usr/bin/env python
import pandas as pd
import numpy as np
from sklearn.linear_model import ElasticNet
from sklearn.preprocessing import scale
from sys import argv

df = argv[1]
y = argv[2]
in_fit_params = argv[3]
random_state = int(argv[4])
out_coef = argv[5]

df = pd.read_csv(df, sep="\t", index_col=0)
y = pd.read_csv(y, sep="\t", index_col=0)

idx = sorted(set(df.index) | set(y.index)) 

df = df.ix[idx]
y = np.array(y.ix[idx])

X = np.array(df)
y = scale(y)

with open(in_fit_params, "r") as f:
    header = next(f)
    best_l1_ratio, best_alpha = next(f).strip().split()
    best_l1_ratio, best_alpha = float(best_l1_ratio), float(best_alpha)

np.random.seed(random_state)
perm = np.random.choice(len(y), len(y))
X_boot, y_boot = np.array(df)[perm,:], y[perm]
model = ElasticNet(l1_ratio=best_l1_ratio, alpha=best_alpha, random_state=random_state)
fit = model.fit(X_boot, y_boot)
coef_df = pd.DataFrame({'coef':fit.coef_})
coef_df.index = df.columns
coef_df.to_csv(out_coef, sep = "\t", index=True)