#!/usr/bin/env python
import pandas as pd
import matplotlib.pyplot as plt
from reddylab_utils.reddylab_plotting_utils import discrete_cmap
from sys import argv

fpr_tpr = argv[1].split(",")
timepoints = argv[2].split(",")
outplot = argv[3]
outplot_zoomed = argv[4]

# fpr_tpr = "predict_binary_output_00h05m.by.all.fpr_tpr.txt,predict_binary_output_00h10m.by.all.fpr_tpr.txt,predict_binary_output_00h15m.by.all.fpr_tpr.txt,predict_binary_output_00h20m.by.all.fpr_tpr.txt,predict_binary_output_00h25m.by.all.fpr_tpr.txt,predict_binary_output_00h30m.by.all.fpr_tpr.txt,predict_binary_output_01h.by.all.fpr_tpr.txt,predict_binary_output_02h.by.all.fpr_tpr.txt,predict_binary_output_03h.by.all.fpr_tpr.txt,predict_binary_output_04h.by.all.fpr_tpr.txt,predict_binary_output_05h.by.all.fpr_tpr.txt,predict_binary_output_06h.by.all.fpr_tpr.txt,predict_binary_output_07h.by.all.fpr_tpr.txt,predict_binary_output_08h.by.all.fpr_tpr.txt,predict_binary_output_10h.by.all.fpr_tpr.txt,predict_binary_output_12h.by.all.fpr_tpr.txt".split(",")
# timepoints = "00h05m,00h10m,00h15m,00h20m,00h25m,00h30m,01h,02h,03h,04h,05h,06h,07h,08h,10h,12h".split(",")
# outplot = "roc.predict_binary_output_across_time.by.all.fpr_tpr.png"
# outplot_zoomed = "roc.predict_binary_output_across_time.by.all.fpr_tpr.zoomed.png"

fpr_tpr = [pd.read_csv(f, sep="\t") for f in fpr_tpr]

colors = discrete_cmap(len(timepoints), 'rainbow')

fig,ax = plt.subplots(figsize=(6,6))
for i,timepoint in enumerate(timepoints):
    ax.plot(fpr_tpr[i]['fpr'], fpr_tpr[i]['tpr'], 
            color=colors[i], label=timepoint)

ax.legend(loc="lower right")
ax.plot([0,1], [0,1], color="black")
plt.savefig(outplot)

fig,ax = plt.subplots(figsize=(6,6))
for i,timepoint in enumerate(timepoints):
    ax.plot(fpr_tpr[i]['fpr'], fpr_tpr[i]['tpr'], 
            color=colors[i], label=timepoint)

ax.set_ylim((0.8, 1.0))
ax.set_xlim((0.0, 0.2))
plt.savefig(outplot_zoomed)
