#!/usr/bin/env python
import pandas as pd
import numpy as np
from sys import argv
import matplotlib.pyplot as plt
from GGR import utils

betas = argv[1].split(",")
timepoints = argv[2].split(",") 
outplot = argv[3]

# betas = "predict_binary_GR_00h05m.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.txt,predict_binary_GR_00h10m.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.txt,predict_binary_GR_00h15m.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.txt,predict_binary_GR_00h20m.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.txt,predict_binary_GR_00h25m.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.txt,predict_binary_GR_00h30m.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.txt,predict_binary_GR_01h.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.txt,predict_binary_GR_02h.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.txt,predict_binary_GR_03h.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.txt,predict_binary_GR_04h.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.txt,predict_binary_GR_05h.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.txt,predict_binary_GR_06h.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.txt,predict_binary_GR_07h.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.txt,predict_binary_GR_08h.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.txt,predict_binary_GR_10h.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.txt,predict_binary_GR_12h.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.txt".split(",")
# timepoints = "00h05m,00h10m,00h15m,00h20m,00h25m,00h30m,01h,02h,03h,04h,05h,06h,07h,08h,10h,12h".split(",")
# outplot = "predict_binary_GR_across_time_course.in.EP300_and_DNase.by_initial_occupancy.coefs.betas.png"

betas = [pd.read_csv(beta, sep="\t", index_col=0) for beta in betas]

cols = sorted(set([col for beta in betas for col in beta.columns]))

beta_df = pd.DataFrame(np.vstack([beta[cols].ix['beta'].values for beta in betas]),
                     index=timepoints, columns=cols)
se_df = pd.DataFrame(np.vstack([beta[cols].ix['beta_se'].values for beta in betas]),
                     index=timepoints, columns=cols)

tableau20 = [(31/255., 119/255., 180/255.), 
             (174/255., 199/255., 232/255.),
             (255/255., 127/255., 14/255.),
             (255/255., 187/255., 120/255.),    
             (44/255., 160/255., 44/255.),
             (152/255., 223/255., 138/255.),
             (214/255., 39/255., 40/255.),
             (255/255., 152/255., 150/255.),    
             (148/255., 103/255., 189/255.),
             (197/255., 176/255., 213/255.),
             (140/255., 86/255., 75/255.),
             (196/255., 156/255., 148/255.),    
             (227/255., 119/255., 194/255.),
             (247/255., 182/255., 210/255.),
             (127/255., 127/255., 127/255.),
             (199/255., 199/255., 199/255.),    
             (188/255., 189/255., 34/255.),
             (219/255., 219/255., 141/255.),
             (23/255., 190/255., 207/255.),
             (158/255., 218/255., 229/255.)]    
tableau10 = tableau20[::2]
if beta_df.shape[1] <= 10:
    colors = tableau10
else:
    colors = tableau20

x = np.arange(beta_df.shape[0])
    
fig,ax = plt.subplots(figsize=(6,6))
for i,col in enumerate(beta_df.columns):
    ax.errorbar(x, 
                beta_df[col], 
                yerr=se_df[col], 
                color=colors[i],
                label=col,
                fmt='-')

utils.adjust_spines(ax,['bottom','left'])
# ax.set_ylim((0,int(np.ceil(max([max(v) for v in beta_d.values()]) * 10))/10.))
ax.legend(loc="best")
ax.set_xticks(x)
ax.set_xticklabels(timepoints)
plt.savefig(outplot)
plt.savefig(outplot.replace(".png",".pdf"))