#!/usr/bin/env python
from sys import argv
import matplotlib.pyplot as plt
import rpy2.robjects as robjects
import numpy as np
from pybedtools import BedTool
from GGR import utils

GR = BedTool(argv[1])
p300 = BedTool(argv[2])
DHSs = BedTool(argv[3])
ymax = float(argv[4])
outplot = argv[5]

# 3134.GR.cort.00m.within_timepoint.union.bed
# 3134.EP300.dex.60m.within_timepoint.union.bed
# 3134.DNase_DHSs.bed 1.5
# enrichment.GR_00m.in.EP300_60m_vs_DNase_DHSs.png

# GR = BedTool("3134.GR.cort.20m.within_timepoint.union.bed")
# p300 = BedTool("3134.EP300.dex.00m.within_timepoint.union.bed")
# DHSs = BedTool("3134.DNase_DHSs.bed")
# ymax = 1.5
# outplot = "enrichment.GR_20m.in.EP300_00m_vs_DNase_DHSs.png"


A = len(p300.intersect(GR, u=True))
B = len(p300.intersect(GR, v=True))
C = len(DHSs.intersect(GR, u=True))
D = len(DHSs.intersect(GR, v=True))

v = robjects.IntVector([A, B, C, D])
m = robjects.r['matrix'](v, nrow = 2)
res = robjects.r['fisher.test'](m)
    
OR = np.log2(res[2][0])
OR_low = np.log2(res[1][0])
OR_hi = np.log2(res[1][1])
     
yerr = OR - OR_low

def simple_bar_with_err_plot(ax, list_of_yvalues, list_of_err_bar, colors):
    import numpy as np
    ax.bar(np.arange(len(list_of_yvalues)) * 0.5 + 0.05, \
           list_of_yvalues, yerr=list_of_err_bar, \
           error_kw=dict(ecolor='black', lw=1, capsize=5, capthick=1), \
            width=0.45, color=colors)

fig,ax = plt.subplots(figsize=(1,3))
simple_bar_with_err_plot(ax, [OR], yerr, 'blue')
ax.set_xticks([0.25])
ax.set_xticklabels([])
utils.adjust_spines(ax,['left','bottom'])
plt.tight_layout()
ax.set_ylim((0,ymax))
plt.savefig(outplot)
plt.savefig(outplot.replace(".png",".pdf"))