#!/usr/bin/env python
import pandas as pd
import numpy as np
import argparse

parser = argparse.ArgumentParser(formatter_class=argparse.RawTextHelpFormatter, \
description="""

normalize_dataframe.py

Given a tab-separated dataframe with a header (by default),
normalize each row.

""")

optional = parser._action_groups.pop()
required = parser.add_argument_group('required arguments')

##################################################
# required args:
required.add_argument("-i", "--df", 
                    help="path to input dataframe ", \
                    required=True)
required.add_argument("-o", "--out", 
                    help="path to output dataframe ", \
                    required=True)

##################################################
# optional args:

optional.add_argument("--no_header", 
                    help="if dataframe lacks a header", \
                    action='store_true')
optional.add_argument("--norm_by_max", 
                    help="divide each cell by max in each row", \
                    action='store_true')

##################################################
parser._action_groups.append(optional)
args = parser.parse_args()

header = 'infer' if not args.no_header else None
in_df = pd.read_csv(args.df, delim_whitespace=True, index_col=0, header=header)
    
if not args.norm_by_max:
    in_df = in_df.div(in_df.sum(axis=1), axis=0)
else:
    in_df = in_df.div(in_df.max(axis=1), axis=0)

header = True if not args.no_header else False
in_df.to_csv(args.out, sep='\t', index=True, header=header)
