#!/usr/bin/env python
from sys import argv
import json

gene_ids = argv[1]

with open(gene_ids, 'r') as f:
    gene_ids = [line.strip() for line in f]

with open('/data/reddylab/Reference_Data/Gencode/v22/gencode.v22.gene_id_to_gene_name.json', 'r') as f:    
    gencode_gene_name_to_gene_symbol = json.load(f)

gene_names = [gencode_gene_name_to_gene_symbol[gene_id] for gene_id in gene_ids]

print('\n'.join(gene_names))
