#!/usr/bin/env Rscript

suppressPackageStartupMessages(library("argparse"))
# create parser object
parser <- ArgumentParser()

# required args
parser$add_argument("-i", "--mat",
 help="Input matrix")
parser$add_argument("-r", "--rds",
 help="Input RDS")
parser$add_argument("-o", "--out",
 help="Output directory")

# optional args
parser$add_argument("-s", "--sv",
 help="Input surrogate variable")
parser$add_argument("-c", "--coef", type="integer",
 help="glm coefficient, e.g. 2")
parser$add_argument("-p", "--prior_count", type="double", default=0.125,
 help="prior.count in glmFit, [default \"%(default)s\"]")
parser$add_argument("--suffix", default="",
 help="suffix to append to output name (before '.txt'), [default \"%(default)s\"]")

args <- parser$parse_args()

if (is.null(args$mat)){
    print("Please provide --mat")
    exit()
}
if (is.null(args$rds)){
    print("Please provide --rds")
    exit()
}
if (is.null(args$out)){
    print("Please provide --out")
    exit()
}

##################################################

suppressPackageStartupMessages(library("edgeR"))

# get model design
mat <- read.table(args$mat, header = T, row.names=1, sep='\t')
timepoint <- factor(sapply(strsplit(as.character(colnames(mat)), "_"), function(x) x[[1]]))
if (!is.null(args$sv)){
    sv <- as.matrix(read.table(args$sv, header = F, sep='\t'))
    model_design <- model.matrix(~timepoint+sv)
}else{
    model_design <- model.matrix(~timepoint)
}

# read y mat
y <- readRDS(args$rds)

# run diff. testing
fit <- glmFit(y, model_design, prior.count=args$prior_count)

if (!is.null(args$coef)){
    de <- as.data.frame(topTags(glmLRT(fit, coef=args$coef), n=dim(y)[1]))
    # find the timepoint tested
    t2 <- as.character(levels(timepoint)[args$coef])
    t1 <- as.character(levels(timepoint)[1])
    # reorder results
    de <- de[order(rownames(de)), ]
    # write results to table
    write.table(file=paste0(args$out, t2, '.vs.', t1, '.', args$suffix, 'txt'), 
                as.data.frame(de, row.names=row.names(de)), sep="\t", quote=F, row.names=T, col.names=NA )
} else {
    de <- as.data.frame(topTags(glmLRT(fit), n=dim(y)[1]))
    # must complete here
}