#!/bin/bash

module load bedtools2

TSS_WINDOWS=$1
GENE_IDS=$2
fraction_overlap_a=$3
INPUT=$4
OUTPUT=$5

NBINS=200

OVERLAP_BINS=`mktemp`
OVERLAP_BED=`mktemp`

bedtools intersect -f $fraction_overlap_a -u -wa \
-a $TSS_WINDOWS -b $INPUT > $OVERLAP_BED

cut -f 4 $OVERLAP_BED > $OVERLAP_BINS

convert_gene_list_and_overlap_bins_to_mask.py \
$GENE_IDS $OVERLAP_BINS $NBINS $OUTPUT