#!/usr/bin/env python
import pandas as pd
from sys import argv

loops_pe = argv[1]
# track_name = argv[2]
out = argv[2]

# loops_pe = "/data/reddylab/projects/GGR/results/integrative/enhancers_by_EP300_analysis/iter0/screenshot_search/loops.annot.bed"
# out = "/data/reddylab/projects/GGR/results/integrative/enhancers_by_EP300_analysis/iter0/screenshot_search/merged_loops.custom.bed"

# create header and write to outfile
# header = 'track name=%s description="%s" itemRgb=On'%(track_name, track_name)

# with open(out, 'w') as f:
#     f.write(header + "\n")

loops_pe = pd.read_csv(loops_pe, header=None, sep="\t", names=["loop_anchor_1_chrom","loop_anchor_1_start","loop_anchor_1_end","loop_anchor__chrom","loop_anchor_2_start","loop_anchor_2_end","itemRGB"])

loops_pe['chrom'] = loops_pe['loop_anchor_1_chrom']
loops_pe['chromStart'] = loops_pe['loop_anchor_1_start']
loops_pe['chromEnd'] = loops_pe['loop_anchor_2_end']
# for name of loop, simply number loops
loops_pe['name'] = ['loop' + str(i+1) for i in range(len(loops_pe))]
loops_pe['score'] = 0
# loops have no strandedness
loops_pe['strand'] = "+"
# "thick" spans entire loop
loops_pe['thickStart'] = loops_pe['loop_anchor_1_start']
loops_pe['thickEnd'] = loops_pe['loop_anchor_2_end']
# "blocks" correspond loop anchors
loops_pe['blockCount'] = 2
loops_pe['blockSizes'] = ["%s,%s,"%(loop_anchor_1_end - loop_anchor_1_start, \
                                    loop_anchor_2_end - loop_anchor_2_start) \
                          for loop_anchor_1_start, loop_anchor_1_end, \
                              loop_anchor_2_start, loop_anchor_2_end in \
                          zip(loops_pe['loop_anchor_1_start'], loops_pe['loop_anchor_1_end'], \
                              loops_pe['loop_anchor_2_start'], loops_pe['loop_anchor_2_end'])]
# blockStarts reference the beginning of the entire feature, here "loop_anchor_1_start"
loops_pe['blockStarts'] = ["0,%s,"%(loop_anchor_2_start-loop_anchor_1_start) \
                           for loop_anchor_1_start, loop_anchor_2_start in \
                           zip(loops_pe['loop_anchor_1_start'], loops_pe['loop_anchor_2_start'])]

col_order = ["chrom","chromStart","chromEnd","name","score",\
             "strand","thickStart","thickEnd","itemRGB",\
             "blockCount","blockSizes","blockStarts"]

with open(out, 'w') as f:
    loops_pe[col_order].to_csv(f, sep="\t", header=False, index=False)
