#!/usr/bin/env python
import pandas as pd
import argparse

parser = argparse.ArgumentParser(formatter_class=argparse.RawTextHelpFormatter, \
description="""

convert_counts_to_proportions.py

Given a dataframe of counts, convert to proportions, normalizing
by the sum of each column.

""")

optional = parser._action_groups.pop()
required = parser.add_argument_group('required arguments')

##################################################
# required args

required.add_argument("-i", "--df", type=str, help="required, dataframe", required=True)
required.add_argument("-o", "--out", type=str, help="required, output dataframe", required=True)

##################################################
# optional args

optional.add_argument("--no_header", 
                    help="if file does not contain a header, then indicate with flag", \
                    action='store_true')

##################################################
parser._action_groups.append(optional)
args = parser.parse_args()

header = 'infer' if not args.no_header else None
df = pd.read_csv(args.df, sep='\t', index_col=0, header=header)

# normalize to proportions
df = df / df.sum()

header = False if args.no_header else True
df.to_csv(args.out, sep='\t', header=header)
