#!/usr/bin/env python
import pandas as pd
import numpy as np
from sys import argv

pvals = argv[1]
logFC = argv[2]
combined_out = argv[3]
ranked_up = argv[4]
ranked_dn = argv[5]


pvals = pd.read_csv(pvals, sep='\t', index_col=0)
# FDRs = pd.read_csv(FDRs, sep='\t', index_col=0)
logFC = pd.read_csv(logFC, sep='\t', index_col=0)

# make sure there are no "floor" effects, that is, that p-values do no hit zero or "near zero"
pvals[pvals == 0.0] = float(1e-323)
assert(pvals.values.min() >  1e-324)
assert(list(pvals.index) == list(logFC.index))

fisher_combined = pd.DataFrame(index=pvals.index)
fisher_combined['fisher_combined'] = -2 * np.log(pvals.values).sum(axis=1)
fisher_combined['mean_logFC'] = logFC.mean(axis=1)
fisher_combined = fisher_combined.sort_values(['fisher_combined'], ascending=False)
fisher_combined_up = fisher_combined[fisher_combined['mean_logFC'] > 0]
fisher_combined_dn = fisher_combined[fisher_combined['mean_logFC'] < 0]

fisher_combined.to_csv(combined_out, sep='\t', index=True)
pd.Series(fisher_combined_up.index).to_csv(ranked_up, sep='\t', index=False)
pd.Series(fisher_combined_dn.index).to_csv(ranked_dn, sep='\t', index=False)
