#!/usr/bin/env Rscript

#library(AnnotationHub)
library(phastCons100way.UCSC.hg38)
#library(GenomicScores)

args<-commandArgs(TRUE)
input_region<-args[1]
output<-args[2]

phast <- getGScores("phastCons100way.UCSC.hg38")

list<-input_region

df<-lapply(list,function(x)read.table(x) )
### data frame to GR range
df<-lapply(df,function(x) 
  makeGRangesFromDataFrame(x,
                           keep.extra.columns=FALSE,
                           ignore.strand=FALSE,
                           seqinfo=NULL,
                           seqnames.field=c("V1"),
                           start.field="V2",
                           end.field=c("V3"),
                           strand.field="strand",
                           starts.in.df.are.0based=FALSE))
names(df)<-gsub(".bed$","",list)

head(df)
df.t<-data.frame(df[[1]])

print(head(df.t))

for(i in 1:nrow(df.t)){
gr<-GRanges(seqnames=df.t$seqnames[i],IRanges(start=df.t$start[i]:df.t$end[i],width=1))
mat<-data.frame(scores(phast,gr))
mat<-data.frame(t(mat$scores))
if(i==1){
  Mat<-mat
}else{
  Mat<-rbind(Mat,mat)
}
}
head(Mat)
Mat[is.na(Mat)]<-0
ave.Mat<-data.frame(conservation.score=apply(Mat,2,function(x)mean(x)))
ave.Mat$bp<-1:nrow(ave.Mat)
ave.Mat<-ave.Mat[!(ave.Mat$bp==401),]
ave.Mat$factor<-names(df)
Dff<-ave.Mat


#compute.avg.singal<-function(x){
#  for(i in 1:nrow(x)){
#    gr<-GRanges(seqnames=x$seqnames[i],IRanges(start=x$start[i]:x$end[i],width=1))
#    mat<-data.frame(scores(phast,gr))
#    mat<-data.frame(t(mat$scores))
#    if(i==1){
#      Mat<-mat
#    }else{
#      Mat<-rbind(Mat,mat)
#    }
#    print(i)
#  }
#  Mat[is.na(Mat)]<-0
# print(Mat)
# ave.Mat<-data.frame(conservation.score=apply(Mat,2,function(x)mean(x)))
#  ave.Mat$bp<-1:nrow(ave.Mat)
# print(ave.Mat)
# ave.Mat<-ave.Mat[!(ave.Mat$bp==401),]
#  return(ave.Mat)
#}


#Df<-lapply(df,function(x) data.frame(x))
#head(Df)
#Dff<-lapply(Df,function(x) compute.avg.singal(x))
#head(Dff)
#Dff<-data.frame(Dff[[1]])
#Dff$factor<-names(df)

write.table(Dff,file=output,row.names = F,col.names = T,sep="\t",quote=F)


