// GenEvo
// Copyright (C) 2019 Institut Pasteur
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

// =========================================================================
// Columns of interest for the download (db key: displayed name)
// =========================================================================

export default {

  // Common fields
  EntrezId: 'Entrez ID',
  Gene: 'Gene',
  GeneLength: 'Gene length',
  GeneType: 'Gene type',
  CDS: 'CDS',

  // dNdS by taxon, Modern humans (dN/dS)
  'highQuality.AN.HS.OmegaHuguet': 'dN/dS high quality - Homo sapiens',
  'mediumQuality.AN.HS.OmegaHuguet': 'dN/dS medium quality - Homo sapiens',
  'lowQuality.AN.HS.OmegaHuguet': 'dN/dS low quality - Homo sapiens',
  'highQuality.AN.altai.OmegaHuguet': 'dN/dS high quality - Altaï',
  'mediumQuality.AN.altai.OmegaHuguet': 'dN/dS medium quality - Altaï',
  'lowQuality.AN.altai.OmegaHuguet': 'dN/dS low quality - Altaï',
  'highQuality.AN.denisovan.OmegaHuguet': 'dN/dS high quality - Denisovan',
  'mediumQuality.AN.denisovan.OmegaHuguet': 'dN/dS medium quality - Denisovan',
  'lowQuality.AN.denisovan.OmegaHuguet': 'dN/dS low quality - Denisovan',
  'highQuality.AN.pantro.OmegaHuguet': 'dN/dS high quality - Pan troglodytes',
  'mediumQuality.AN.pantro.OmegaHuguet': 'dN/dS medium quality - Pan troglodytes',
  'lowQuality.AN.pantro.OmegaHuguet': 'dN/dS low quality - Pan troglodytes',
  'highQuality.AN.gorGor3.OmegaHuguet': 'dN/dS high quality - Gorilla gorilla',
  'mediumQuality.AN.gorGor3.OmegaHuguet': 'dN/dS medium quality - Gorilla gorilla',
  'lowQuality.AN.gorGor3.OmegaHuguet': 'dN/dS low quality - Gorilla gorilla',
  'highQuality.AN.ponAbe2.OmegaHuguet': 'dN/dS high quality - Pongo abelii',
  'mediumQuality.AN.ponAbe2.OmegaHuguet': 'dN/dS medium quality - Pongo abelii',
  'lowQuality.AN.ponAbe2.OmegaHuguet': 'dN/dS low quality - Pongo abelii',
  'highQuality.AN.rheMac3.OmegaHuguet': 'dN/dS high quality - Macaca mulatta',
  'mediumQuality.AN.rheMac3.OmegaHuguet': 'dN/dS medium quality - Macaca mulatta',
  'lowQuality.AN.rheMac3.OmegaHuguet': 'dN/dS low quality - Macaca mulatta',
  'highQuality.AN.calJac3.OmegaHuguet': 'dN/dS high quality - Callithrix jacchus',
  'mediumQuality.AN.calJac3.OmegaHuguet': 'dN/dS medium quality - Callithrix jacchus',
  'lowQuality.AN.calJac3.OmegaHuguet': 'dN/dS low quality - Callithrix jacchus',

  // Modern humans (pN/pS)
  pNpS001: 'pN/pS 1% - Homo sapiens',
  pNpS005: 'pN/pS 5% - Homo sapiens',
  pNpSGlobal: 'pN/pS all - Homo sapiens',

  // Primate evolution (dN)
  'highQuality.AN.HS.dN': 'dN high quality - Homo sapiens',
  'mediumQuality.AN.HS.dN': 'dN medium quality - Homo sapiens',
  'lowQuality.AN.HS.dN': 'dN low quality - Homo sapiens',
  'highQuality.AN.altai.dN': 'dN high quality - Altaï',
  'mediumQuality.AN.altai.dN': 'dN medium quality - Altaï',
  'lowQuality.AN.altai.dN': 'dN low quality - Altaï',
  'highQuality.AN.denisovan.dN': 'dN high quality - Denisovan',
  'mediumQuality.AN.denisovan.dN': 'dN medium quality - Denisovan',
  'lowQuality.AN.denisovan.dN': 'dN low quality - Denisovan',
  'highQuality.AN.pantro.dN': 'dN high quality - Pan troglodytes',
  'mediumQuality.AN.pantro.dN': 'dN medium quality - Pan troglodytes',
  'lowQuality.AN.pantro.dN': 'dN low quality - Pan troglodytes',
  'highQuality.AN.gorGor3.dN': 'dN high quality - Gorilla gorilla',
  'mediumQuality.AN.gorGor3.dN': 'dN medium quality - Gorilla gorilla',
  'lowQuality.AN.gorGor3.dN': 'dN low quality - Gorilla gorilla',
  'highQuality.AN.ponAbe2.dN': 'dN high quality - Pongo abelii',
  'mediumQuality.AN.ponAbe2.dN': 'dN medium quality - Pongo abelii',
  'lowQuality.AN.ponAbe2.dN': 'dN low quality - Pongo abelii',
  'highQuality.AN.rheMac3.dN': 'dN high quality - Macaca mulatta',
  'mediumQuality.AN.rheMac3.dN': 'dN medium quality - Macaca mulatta',
  'lowQuality.AN.rheMac3.dN': 'dN low quality - Macaca mulatta',
  'highQuality.AN.calJac3.dN': 'dN high quality - Callithrix jacchus',
  'mediumQuality.AN.calJac3.dN': 'dN medium quality - Callithrix jacchus',
  'lowQuality.AN.calJac3.dN': 'dN low quality - Callithrix jacchus',

  // Primate evolution (dS)
  'highQuality.AN.HS.dS': 'dS high quality - Homo sapiens',
  'mediumQuality.AN.HS.dS': 'dS medium quality - Homo sapiens',
  'lowQuality.AN.HS.dS': 'dS low quality - Homo sapiens',
  'highQuality.AN.altai.dS': 'dS high quality - Altaï',
  'mediumQuality.AN.altai.dS': 'dS medium quality - Altaï',
  'lowQuality.AN.altai.dS': 'dS low quality - Altaï',
  'highQuality.AN.denisovan.dS': 'dS high quality - Denisovan',
  'mediumQuality.AN.denisovan.dS': 'dS medium quality - Denisovan',
  'lowQuality.AN.denisovan.dS': 'dS low quality - Denisovan',
  'highQuality.AN.pantro.dS': 'dS high quality - Pan troglodytes',
  'mediumQuality.AN.pantro.dS': 'dS medium quality - Pan troglodytes',
  'lowQuality.AN.pantro.dS': 'dS low quality - Pan troglodytes',
  'highQuality.AN.gorGor3.dS': 'dS high quality - Gorilla gorilla',
  'mediumQuality.AN.gorGor3.dS': 'dS medium quality - Gorilla gorilla',
  'lowQuality.AN.gorGor3.dS': 'dS low quality - Gorilla gorilla',
  'highQuality.AN.ponAbe2.dS': 'dS high quality - Pongo abelii',
  'mediumQuality.AN.ponAbe2.dS': 'dS medium quality - Pongo abelii',
  'lowQuality.AN.ponAbe2.dS': 'dS low quality - Pongo abelii',
  'highQuality.AN.rheMac3.dS': 'dS high quality - Macaca mulatta',
  'mediumQuality.AN.rheMac3.dS': 'dS medium quality - Macaca mulatta',
  'lowQuality.AN.rheMac3.dS': 'dS low quality - Macaca mulatta',
  'highQuality.AN.calJac3.dS': 'dS high quality - Callithrix jacchus',
  'mediumQuality.AN.calJac3.dS': 'dS medium quality - Callithrix jacchus',
  'lowQuality.AN.calJac3.dS': 'dS low quality - Callithrix jacchus',

  // Introgression (CCDS)
  CCDS_PEUR: 'CCDS Europe',
  CCDS_PASN: 'CCDS Asia',

  // Human left hemisphere (genes specificity)
  'ctx-lh-paracentral_Specificity': 'Paracentral - Specificity',
  'ctx-lh-medialorbitofrontal_Specificity': 'Medial orbitofrontal - Specificity',
  'ctx-lh-superiortemporal_Specificity': 'Superior temporal - Specificity',
  'ctx-lh-parahippocampal_Specificity': 'Parahippocampal - Specificity',
  'ctx-lh-precuneus_Specificity': 'Precuneus - Specificity',
  'ctx-lh-inferiortemporal_Specificity': 'Inferior temporal - Specificity',
  'ctx-lh-isthmuscingulate_Specificity': 'Isthmus of cingulate gyrus - Specificity',
  'ctx-lh-entorhinal_Specificity': 'Entorhinal - Specificity',
  'ctx-lh-superiorparietal_Specificity': 'Superior parietal - Specificity',
  'ctx-lh-parsorbitalis_Specificity': 'Pars orbitalis - Specificity',
  'ctx-lh-fusiform_Specificity': 'Fusiform - Specificity',
  'ctx-lh-superiorfrontal_Specificity': 'Superior frontal - Specificity',
  'ctx-lh-rostralanteriorcingulate_Specificity': 'Rostral anterior cingulate - Specificity',
  'ctx-lh-precentral_Specificity': 'Precentral - Specificity',
  'ctx-lh-cuneus_Specificity': 'Cuneus - Specificity',
  'ctx-lh-parsopercularis_Specificity': 'Pars opercularis - Specificity',
  'ctx-lh-insula_Specificity': 'Insula - Specificity',
  'ctx-lh-transversetemporal_Specificity': 'Transverse temporal - Specificity',
  'ctx-lh-inferiorparietal_Specificity': 'Inferior parietal - Specificity',
  'ctx-lh-pericalcarine_Specificity': 'Pericalcarine - Specificity',
  'ctx-lh-postcentral_Specificity': 'Postcentral - Specificity',
  'ctx-lh-supramarginal_Specificity': 'Supramarginal - Specificity',
  'ctx-lh-rostralmiddlefrontal_Specificity': 'Rostral middle frontal - Specificity',
  'ctx-lh-frontalpole_Specificity': 'Frontal pole - Specificity',
  'ctx-lh-lingual_Specificity': 'Lingual - Specificity',
  'ctx-lh-lateralorbitofrontal_Specificity': 'Lateral orbital - Specificity',
  'ctx-lh-bankssts_Specificity': 'Banks of superior temporal sulcus - Specificity',
  'ctx-lh-caudalanteriorcingulate_Specificity': 'Caudal anterior cingulate - Specificity',
  'ctx-lh-lateraloccipital_Specificity': 'Lateral occipital - Specificity',
  'ctx-lh-posteriorcingulate_Specificity': 'Posterior cingulate - Specificity',
  'ctx-lh-parstriangularis_Specificity': 'Pars triangularis - Specificity',
  'ctx-lh-middletemporal_Specificity': 'Middle temporal - Specificity',
  'ctx-lh-caudalmiddlefrontal_Specificity': 'Caudal middle frontal - Specificity',
  'ctx-lh-temporalpole_Specificity': 'Temporal pole - Specificity',

  // Human left hemisphere (expression levels)
  'ctx-lh-paracentral_Levels': 'Paracentral - Expression',
  'ctx-lh-medialorbitofrontal_Levels': 'Medial orbitofrontal - Expression',
  'ctx-lh-superiortemporal_Levels': 'Superior temporal - Expression',
  'ctx-lh-parahippocampal_Levels': 'Parahippocampal - Expression',
  'ctx-lh-precuneus_Levels': 'Precuneus - Expression',
  'ctx-lh-inferiortemporal_Levels': 'Inferior temporal - Expression',
  'ctx-lh-isthmuscingulate_Levels': 'Isthmus of cingulate gyrus - Expression',
  'ctx-lh-entorhinal_Levels': 'Entorhinal - Expression',
  'ctx-lh-superiorparietal_Levels': 'Superior parietal - Expression',
  'ctx-lh-parsorbitalis_Levels': 'Pars orbitalis - Expression',
  'ctx-lh-fusiform_Levels': 'Fusiform - Expression',
  'ctx-lh-superiorfrontal_Levels': 'Superior frontal - Expression',
  'ctx-lh-rostralanteriorcingulate_Levels': 'Rostral anterior cingulate - Expression',
  'ctx-lh-precentral_Levels': 'Precentral - Expression',
  'ctx-lh-cuneus_Levels': 'Cuneus - Expression',
  'ctx-lh-parsopercularis_Levels': 'Pars opercularis - Expression',
  'ctx-lh-insula_Levels': 'Insula - Expression',
  'ctx-lh-transversetemporal_Levels': 'Transverse temporal - Expression',
  'ctx-lh-inferiorparietal_Levels': 'Inferior parietal - Expression',
  'ctx-lh-pericalcarine_Levels': 'Pericalcarine - Expression',
  'ctx-lh-postcentral_Levels': 'Postcentral - Expression',
  'ctx-lh-supramarginal_Levels': 'Supramarginal - Expression',
  'ctx-lh-rostralmiddlefrontal_Levels': 'Rostral middle frontal - Expression',
  'ctx-lh-frontalpole_Levels': 'Frontal pole - Expression',
  'ctx-lh-lingual_Levels': 'Lingual - Expression',
  'ctx-lh-lateralorbitofrontal_Levels': 'Lateral orbital - Expression',
  'ctx-lh-bankssts_Levels': 'Banks of superior temporal sulcus - Expression',
  'ctx-lh-caudalanteriorcingulate_Levels': 'Caudal anterior cingulate - Expression',
  'ctx-lh-lateraloccipital_Levels': 'Lateral occipital - Expression',
  'ctx-lh-posteriorcingulate_Levels': 'Posterior cingulate - Expression',
  'ctx-lh-parstriangularis_Levels': 'Pars triangularis - Expression',
  'ctx-lh-middletemporal_Levels': 'Middle temporal - Expression',
  'ctx-lh-caudalmiddlefrontal_Levels': 'Caudal middle frontal - Expression',
  'ctx-lh-temporalpole_Levels': 'Temporal pole - Expression',

  // Fetal brain, Adult brain (Expression specificity)
  preR1_gn: 'Fetal brain R1',
  pstR1_gn: 'Adult brain R1',
  preR2_gn: 'Fetal brain R2',
  pstR2_gn: 'Adult brain R2',
  preR3_gn: 'Fetal brain R3',
  pstR3_gn: 'Adult brain R3',
  preR4_gn: 'Fetal brain R4',
  pstR4_gn: 'Adult brain R4'
}
