library(ggplot2)
perm8 <- read.table("TE.LTR.uniq.bed.permutation.breaks.bed", header = F)
obs8 <- 60
ggplot(data = perm8) +
        #geom_histogram(aes(x=V1),bins = 70, color='black', fill='gold1') +
        geom_histogram(aes(x=V1, y=..density..),binwidth = 1, color='black', fill='gold1') +
        geom_density(aes(x=V1), color='blue',size=1) +
    #stat_function(fun = dnorm, args = list(mean = mean(perm8$V1), sd = sd(perm8$V1)))
        geom_vline(aes(xintercept = obs8), color='red') +
        labs(title="DNA-type TE",x='Counts', y= 'Frequency' ) +
    scale_y_continuous(
            # Features of the first axis
            name = "Frequency",
            breaks=seq(0,0.03,0.005),
            # Add a se0cond axis and specify its features
            sec.axis = sec_axis(trans = ~.*10000, name="Counts")
        ) +
 theme_bw() +
      theme(
          panel.grid = element_line(color="grey85"),
           plot.title = element_text(size = 18, face = "bold",hjust=.5),
         axis.text.x = element_text(colour="grey20",size=11,hjust=.5,vjust=.5,face="plain"),
          axis.text.y = element_text(colour="grey20",size=11,hjust=.5,vjust=.5,face="plain"),
          axis.title.y = element_text(colour="grey20",size=13,hjust=.5,vjust=.5,face="bold"))
pvalue_exp <-  min(sum(obs8 < perm8), sum(obs8 > perm8)) * 2 / length(perm8$V1)
