library(ggplot2)


## For Dmel insertions
setwd("/home/yiliao/Documents/20191204_Dpse_Paper_Final/Figures/Figure7/March")
mydata1<- read.table ("pop.nonTE.ins.bed.uniq.bed1_10bp.peak.breatpoints.bed.bed")
mydata2<- read.table ("pop.nonTE.ins.bed.uniq.bed11_20kb.peak.breatpoints.bed.bed")

mymean1 <- 3677
mymean2 <- 2444
mymean <- 6121
mydata_12 <- merge.data.frame(mydata1, mydata2, by=1, all =T)

ggplot(mydata_12,aes(x=V1,y=(V2.x-mymean1)/mymean1) ) + 
  annotate(geom="rect", xmin=-100,xmax= 100, ymin= (6047-mymean)/mymean, ymax=(6301-mymean)/mymean,fill="grey", alpha = 0.8) +
  geom_hline(yintercept = 0,linetype=2) + 
  geom_line(color='orange') + 
  geom_smooth(span=0.1, color="black",se=FALSE) + 
  geom_point(size=0.5) + 
  geom_line(aes(y = (V2.y-mymean2)/mymean2), color='red') + 
  geom_smooth(aes(y = (V2.y-mymean2)/mymean2), span=0.1, color="brown",se=FALSE) + 
  geom_point(aes(y = (V2.y-mymean2)/mymean2), size=0.5, color="red") + 
  scale_y_continuous(limits=c(-0.4,0.2)) + 
  scale_x_continuous(limits=c(-100,100), expand=c(0,0)) +
  labs(x="Distance to TAD boundary" , y="Fold change", title ="Dmel Insertions") +
  theme_bw()

##########For Dsim insertions

setwd("/home/yiliao/Documents/20191204_Dpse_Paper_Final/Figures/Figure7/March")
mydata1<- read.table ("3p.NonTE.ins.bed.uniq.bed1_10bp.peak.breatpoints.bed.bed")
mydata2<- read.table ("3p.NonTE.ins.bed.uniq.bed11_20kb.peak.breatpoints.bed.bed")
mymean1 <- 13579
mymean2 <- 7446
mymean <- 21025
mydata_12 <- merge.data.frame(mydata1, mydata2, by=1, all =T)
ggplot(mydata_12,aes(x=V1,y=(V2.x-mymean1)/mymean1) ) + 
  annotate(geom="rect", xmin=-100,xmax= 100, ymin= (20965-mymean)/mymean, ymax=(21421-mymean)/mymean,fill="grey", alpha = 0.8) +
  geom_hline(yintercept = 0,linetype=2) + 
  geom_line(color='orange') + 
  geom_smooth(span=0.1, color="black",se=FALSE) + 
  geom_point(size=0.5) + 
  geom_line(aes(y = (V2.y-mymean2)/mymean2), color='red') + 
  geom_smooth(aes(y = (V2.y-mymean2)/mymean2), span=0.1, color="brown",se=FALSE) + 
  geom_point(aes(y = (V2.y-mymean2)/mymean2), size=0.5, color="red") + 
  scale_y_continuous(limits=c(-0.2,0.1)) + 
  scale_x_continuous(limits=c(-100,100), expand=c(0,0)) +
  labs(x="Distance to TAD boundary" , y="Fold change", title ="Dsim insertions") +
  theme_bw()


##### For Dmel deletions

setwd("/home/yiliao/Documents/20191204_Dpse_Paper_Final/Figures/Figure7/March")

mydata1<- read.table ("pop.del.bed.uniq.breakpionts.bed1_10bp.peak.breatpoints.bed.bed")
mydata2<- read.table ("pop.del.bed.uniq.breakpionts.bed11_2000bp.peak.breatpoints.bed.bed")

mymean1 <- 18181
mymean2 <- 5110
mymean <- 23291
mydata_12 <- merge.data.frame(mydata1, mydata2, by=1, all =T)
ggplot(mydata_12,aes(x=V1,y=(V2.x-mymean1)/mymean1) ) + 
  annotate(geom="rect", xmin=-100,xmax= 100, ymin= (23283-mymean)/mymean, ymax=(23759-mymean)/mymean,fill="grey", alpha = 0.8) +
  geom_hline(yintercept = 0,linetype=2) + 
  geom_line(color='orange') + 
  geom_smooth(span=0.1, color="black",se=FALSE) + 
  geom_point(size=0.5) + 
  geom_line(aes(y = (V2.y-mymean2)/mymean2), color='red') + 
  geom_smooth(aes(y = (V2.y-mymean2)/mymean2), span=0.1, color="brown",se=FALSE) + 
  geom_point(aes(y = (V2.y-mymean2)/mymean2), size=0.5, color="red") +
  scale_y_continuous(limits=c(-0.25,0.1)) + 
  scale_x_continuous(limits=c(-100,100), expand=c(0,0)) +
  labs(x="Distance to TAD boundary" , y="Fold change", title ="Dmel Deletions") +
  theme_bw()

###############For Dsim deletion
setwd("/home/yiliao/Documents/20191204_Dpse_Paper_Final/Figures/Figure7/March")
mydata1<- read.table ("3p.del.bed.uniq.breakpionts.bed1_10bp.peak.breatpoints.bed.bed")
mydata2<- read.table ("3p.del.bed.uniq.breakpionts.bed11_2000bp.peak.breatpoints.bed.bed")

mymean1 <- 58657
mymean2 <- 16602
mymean <- 75259
mydata_12 <- merge.data.frame(mydata1, mydata2, by=1, all =T)
ggplot(mydata_12,aes(x=V1,y=(V2.x-mymean1)/mymean1) ) + 
  annotate(geom="rect", xmin=-100,xmax= 100, ymin= (75336-mymean)/mymean, ymax=(76208-mymean)/mymean,fill="grey", alpha = 0.8) +
  geom_hline(yintercept = 0,linetype=2) + 
  geom_line(color='orange') + 
  geom_smooth(span=0.1, color="black",se=FALSE) + 
  geom_point(size=0.5) + 
  geom_line(aes(y = (V2.y-mymean2)/mymean2), color='red') + 
  geom_smooth(aes(y = (V2.y-mymean2)/mymean2), span=0.1, color="brown",se=FALSE) + 
  geom_point(aes(y = (V2.y-mymean2)/mymean2), size=0.5, color="red") + 
  scale_y_continuous(limits=c(-0.25,0.1)) + 
  scale_x_continuous(limits=c(-100,100), expand=c(0,0)) +
  labs(x="Distance to TAD boundary" , y="Fold change", title ="Dsim Deletions") +
  theme_bw()




############## For Dmel short and long deletions
mydata1<- read.table ("All.result.txt.out.sort.euchromatin.bed.uniq.breakpionts.bed11_2000bp.peak.breatpoints.bed.bed")
mydata2<- read.table ("All.result.txt.out.sort.euchromatin.bed.uniq.breakpionts.bed1_10bp.peak.breatpoints.bed.bed")
mymean1 <- 4781
mymean2 <- 16608
mydata_12 <- merge.data.frame(mydata1, mydata2, by=1, all =T)

ggplot(mydata_12,aes(x=V1,y=(V2.x-mymean1)/mymean1) ) + 
  annotate(geom="rect", xmin=-100,xmax= 100, ymin= -0.05, ymax=0.05,fill="grey", alpha = 0.8) +
  geom_hline(yintercept = 0,linetype=2) + 
  geom_line(color='orange') + 
  geom_smooth(span=0.1, color="black",se=FALSE) + 
  geom_point(size=0.5) + 
  geom_line(aes(y = (V2.y-mymean2)/mymean2), color='red') + 
  geom_smooth(aes(y = (V2.y-mymean2)/mymean2), span=0.1, color="brown",se=FALSE) + 
  geom_point(aes(y = (V2.y-mymean2)/mymean2), size=0.5, color="red") + 
  scale_y_continuous(limits=c(-0.25,0.1)) + 
  scale_x_continuous(limits=c(-100,100), expand=c(0,0)) +
  labs(x="Distance to TAD boundary" , y="Fold change", title ="Short versus Long deletions") +
  theme_bw()

######### For Dmel rare and common deletions
setwd("/home/yiliao/Documents/20191204_Dpse_Paper_Final/Figures/Figure7/Dmelpop")

mydata1<- read.table ("All.result.txt.out.sort.euchromatin.bed.uniq.breakpoints.bed_rare.peak.breatpoints.bed.bed")
mydata2<- read.table ("All.result.txt.out.sort.euchromatin.bed.uniq.breakpoints.bed_common.peak.breatpoints.bed.bed")
mymean1 <- 12982
mymean2 <- 8407
mydata_12 <- merge.data.frame(mydata1, mydata2, by=1, all =T)
ggplot(mydata_12,aes(x=V1,y=(V2.x-mymean1)/mymean1) ) + 

  annotate(geom="rect", xmin=-100,xmax= 100, ymin= -0.05, ymax=0.05,fill="grey", alpha = 0.8) +
  geom_hline(yintercept = 0,linetype=2) + 
  geom_line(color='orange') + 
  geom_smooth(span=0.1, color="black",se=FALSE) + 
  geom_point(size=0.5) + 
  geom_line(aes(y = (V2.y-mymean2)/mymean2), color='red') + 
  geom_smooth(aes(y = (V2.y-mymean2)/mymean2), span=0.1, color="brown",se=FALSE) + 
  geom_point(aes(y = (V2.y-mymean2)/mymean2), size=0.5, color="red") + 
  
  scale_y_continuous(limits=c(-0.25,0.1)) + 
  scale_x_continuous(limits=c(-100,100), expand=c(0,0)) +
  labs(x="Distance to TAD boundary" , y="Fold change", title ="Rare versus common deletions") +
  theme_bw()

