library(ggplot2)
## Total INS
fisher.test(x = matrix(c(3914, 79169, 18269, 267140), nc = 2)[2:1,])
## 1-10bp INS
fisher.test(x = matrix(c(2450, 47462, 11287, 173042), nc = 2)[2:1,])
## 11bp - 20kb INS
fisher.test(x = matrix(c(1464, 31707, 6982, 94098), nc = 2)[2:1,])
## Total DEL
fisher.test(x = matrix(c(19044, 139031, 68093, 442705), nc = 2)[2:1,])
## 1-10 bp DEL
fisher.test(x = matrix(c(15135, 108260, 54599, 343518), nc = 2)[2:1,])
## 11bp -2kb DEL
fisher.test(x = matrix(c(3909, 30771, 13494, 99187), nc = 2)[2:1,])
## Total TE
fisher.test(x = matrix(c(405, 6727, 120, 1696), nc = 2)[2:1,])
## LTR
fisher.test(x = matrix(c(154, 3382, 28, 368), nc = 2)[2:1,])
## LINE
fisher.test(x = matrix(c(124, 2118, 34, 493), nc = 2)[2:1,])
## DNA-type TE
fisher.test(x = matrix(c(127, 1225, 60, 842), nc = 2)[2:1,])
## CNVs
fisher.test(x = matrix(c(181, 3425, 287, 2295), nc = 2)[2:1,])

# Create labels for plot
boxLabels = c("A Total insertions", "B 1-10bp insertions", "C 11bp-20kb insertions", "D Total deletions", "E 1-10bp deletions", 
              "F 11bp-2kb deletions", "H Total TEs", "I LTRs", "J LINEs", "Q DNA-type TEs", "Z Tandem duplications")

# Enter OR and CI data. boxOdds are the odds ratios, 
# boxCILow is the lower bound of the CI, boxCIHigh is the upper bound.

df <- data.frame(yAxis = length(boxLabels):1, 
                 boxOdds = c(1.38, 1.26, 1.61, 1.12, 1.14, 1.07, 1.18, 1.67, 1.18, 0.69, 2.21), 
                 boxCILow = c(1.34, 1.21, 1.52, 1.1, 1.12, 1.03, 0.94, 1.06, 0.77, 0.49, 1.82), 
                 boxCIHigh = c(1.43, 1.32, 1.7, 1.14, 1.16, 1.11, 1.45, 2.55, 1.76, 0.95, 2.7))

# Plot
p <- ggplot(df, aes(x = boxOdds, y = boxLabels)) +
    geom_vline(aes(xintercept = 1), size = .25, linetype = 'dashed') +
    geom_errorbarh(aes(xmax = boxCIHigh, xmin = boxCILow), size = .5, height = 
                     .2, color = 'gray50') +
    geom_point(size = 3.5, color = 'orange') +
    theme_bw() +
    theme(panel.grid.minor = element_blank()) +
    scale_x_continuous(breaks = seq(0,7,1) ) +
    ylab('') +
    xlab('Odds ratio')
   # annotate(geom = 'text', y =1.1, x = 3.5, label ='Model p < 0.001\nPseudo R^2 = 0.10', size = 3.5, hjust = 0) + ggtitle('Intention to remove box turtles from the road')
p

