library(ggplot2)
library(ggrepel)

setwd("/home/yiliao/Documents/20191204_Dpse_Paper_Final/Figures/Figure7")

data <-read.table("Purifying.txt")
#x<-data[,2]
#y<-data[,3]
#a<-paste0("ID_",c(1:25))


tdf <- data.frame(x=data[,3],y=data[,4],a=data[,2], b = data[,1])
tdf$a <- factor(tdf$a, levels=tdf$a)  # keep the order in legend the same.

ggplot(data = tdf) + geom_point(aes(x=x,y=y,color=a,shape=factor(b)), size=3) +
  geom_text_repel(aes(x=x, y =y , label = a, ,color=a), size= 2.5) + 
  scale_x_continuous(limits = c(-0.4,0.4)) +
  scale_y_continuous(limits=c(-0.4,0.4)) + 
  labs(x="log10(breakpoints/expected)" , y="log10(cov/expected)", title ="Purifying selection signal",shape="species",color="SV types") +
  #guides(color=FALSE, fill=FALSE) + 
  theme_bw() + 
  theme(
    #legend.position = c(0.8,0.1),
    legend.title = element_text(size=15),
    legend.text=element_text(size=13),
    panel.grid = element_line(color="grey85"),  
    plot.title = element_text(size = 18, face = "bold",hjust=.5),
    axis.text.x = element_text(colour="grey20",size=13,hjust=.5,vjust=.5,face="plain"),
    axis.text.y = element_text(colour="grey20",size=13,hjust=.5,vjust=.5,face="plain"),
    axis.title.x = element_text(colour="grey20",size=15,hjust=.5,vjust=0,face="bold"), 
    #axis.title = element_blank(),
    axis.title.y = element_text(colour="grey20",size=15,hjust=.5,vjust=.5,face="bold"))









