#library(dplyr)
#dat_df <- read.table("/home/yiliao/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dyak.all.chain.filter.tnet.synnet.breaks.out.bed.sort.merge.background.bed")
#dat_df_prop <- dat_df %>% mutate(total= rowSums(.[,1:20]))

###########################################################################################################
############################  Here below is for Dmel ######################################################
###########################################################################################################


#### For Dmau Dsec Dsim Dyak

setwd("~/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dmel")

jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(m+c(-1, 0, 1)*s)) }

dat1 <- matrix(as.numeric(scan(file = 'Dmau.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs1 = rowSums(dat1)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x/rs1) 
ans1 <- apply(X = tmp1, MARGIN = 2, FUN = jfunc)

dat2 <- matrix(as.numeric(scan(file = 'Dsec.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs2 = rowSums(dat2)
tmp2 <- apply(X=dat2, MARGIN = 2, function(x) x/rs2) 
ans2 <- apply(X = tmp2, MARGIN = 2, FUN = jfunc)

dat3 <- matrix(as.numeric(scan(file = 'Dsim.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs3 = rowSums(dat3)
tmp3 <- apply(X=dat3, MARGIN = 2, function(x) x/rs3) 
ans3 <- apply(X= tmp3, MARGIN = 2, FUN = jfunc)

dat4 <- matrix(as.numeric(scan(file = 'Dyak.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs4 = rowSums(dat4)
tmp4 <- apply(X=dat4, MARGIN = 2, function(x) x/rs4) 
ans4 <- apply(X = tmp4, MARGIN = 2, FUN = jfunc)


dere <- as.numeric(scan(file = 'Dmau.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
derep <- dere/sum(dere)
deug <- as.numeric(scan(file = 'Dsec.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
deugp <- deug/sum(deug)
dsim <- as.numeric(scan(file = 'Dsim.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dsimp <- dsim/sum(dsim)
dyak<- as.numeric(scan(file = 'Dyak.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dyakp <- dyak/sum(dyak)

plot(xlab="D. melanogaster TAD",ylab="Syntenic or chromosomal arrangement breakpoints [%]",-1,-1,ylim = range(dyakp), xlim = c(1,20)) ##
polygon(y = t(ans1[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)
#polygon(y = t(ans2[c(1,3),]), x = c(1:20, 20:1), col = 'green', border = NA)
#polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'blue', border = NA)
#polygon(y = t(ans4[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)

lines(ans1[2,],col='blue4',lty="dashed")
lines(ans2[2,],col='aquamarine4',lty="dashed")
lines(ans3[2,],col='brown1',lty="dashed")
lines(ans4[2,],col='darkorchid4',lty="dashed")
lines(dmaup, col = 'blue4', lwd=2)
lines(dsecp, col = 'aquamarine4', lwd=2)
lines(dsimp, col = 'brown1', lwd=2)
lines(dyakp, col = 'darkorchid4', lwd=2)
abline(v=5.5,lty="dashed")
abline(v=15.5,lty="dashed")





#### For Dmau Dsec Dsim Dyak

setwd("~/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dmel")

jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(m+c(-1, 0, 1)*s)) }

dat1 <- matrix(as.numeric(scan(file = 'Dmau.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs1 = rowSums(dat1)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x/rs1) 
ans1 <- apply(X = tmp1, MARGIN = 2, FUN = jfunc)

dat2 <- matrix(as.numeric(scan(file = 'Dsec.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs2 = rowSums(dat2)
tmp2 <- apply(X=dat2, MARGIN = 2, function(x) x/rs2) 
ans2 <- apply(X = tmp2, MARGIN = 2, FUN = jfunc)

dat3 <- matrix(as.numeric(scan(file = 'Dsim.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs3 = rowSums(dat3)
tmp3 <- apply(X=dat3, MARGIN = 2, function(x) x/rs3) 
ans3 <- apply(X= tmp3, MARGIN = 2, FUN = jfunc)

dat4 <- matrix(as.numeric(scan(file = 'Dyak.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs4 = rowSums(dat4)
tmp4 <- apply(X=dat4, MARGIN = 2, function(x) x/rs4) 
ans4 <- apply(X = tmp4, MARGIN = 2, FUN = jfunc)


dere <- as.numeric(scan(file = 'Dmau.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
derep <- dere/sum(dere)
deug <- as.numeric(scan(file = 'Dsec.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
deugp <- deug/sum(deug)
dsim <- as.numeric(scan(file = 'Dsim.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dsimp <- dsim/sum(dsim)
dyak<- as.numeric(scan(file = 'Dyak.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dyakp <- dyak/sum(dyak)

plot(xlab="D. melanogaster TAD",ylab="Inversion breakpoints [%]",-1,-1,ylim = range(dsimp), xlim = c(1,20)) ##
polygon(y = t(ans1[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)
#polygon(y = t(ans2[c(1,3),]), x = c(1:20, 20:1), col = 'green', border = NA)
#polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'blue', border = NA)
#polygon(y = t(ans4[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)

lines(ans1[2,],col='blue4',lty="dashed")
lines(ans2[2,],col='aquamarine4',lty="dashed")
lines(ans3[2,],col='brown1',lty="dashed")
lines(ans4[2,],col='darkorchid4',lty="dashed")
lines(dmaup, col = 'blue4', lwd=2)
lines(dsecp, col = 'aquamarine4', lwd=2)
lines(dsimp, col = 'brown1', lwd=2)
lines(dyakp, col = 'darkorchid4', lwd=2)
abline(v=5.5,lty="dashed")
abline(v=15.5,lty="dashed")






### For Dere Deug Dmiranda Dmoj

setwd("~/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dmel")

jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(m+c(-1, 0, 1)*s)) }

dat1 <- matrix(as.numeric(scan(file = 'Dere.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs1 = rowSums(dat1)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x/rs1) 
ans1 <- apply(X = tmp1, MARGIN = 2, FUN = jfunc)

dat2 <- matrix(as.numeric(scan(file = 'Deug.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs2 = rowSums(dat2)
tmp2 <- apply(X=dat2, MARGIN = 2, function(x) x/rs2) 
ans2 <- apply(X = tmp2, MARGIN = 2, FUN = jfunc)

dat3 <- matrix(as.numeric(scan(file = 'Dmiranda.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs3 = rowSums(dat3)
tmp3 <- apply(X=dat3, MARGIN = 2, function(x) x/rs3) 
ans3 <- apply(X= tmp3, MARGIN = 2, FUN = jfunc)

dat4 <- matrix(as.numeric(scan(file = 'Dmoj.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs4 = rowSums(dat4)
tmp4 <- apply(X=dat4, MARGIN = 2, function(x) x/rs4) 
ans4 <- apply(X = tmp4, MARGIN = 2, FUN = jfunc)


dere <- as.numeric(scan(file = 'Dere.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
derep <- dere/sum(dere)
deug <- as.numeric(scan(file = 'Deug.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
deugp <- deug/sum(deug)
dmiranda <- as.numeric(scan(file = 'Dmiranda.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dmirandap <- dmiranda/sum(dmiranda)
dmoj<- as.numeric(scan(file = 'Dmoj.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dmojp <- dmoj/sum(dmoj)

plot(xlab="D. melanogaster TAD",ylab="Inversion breakpoints [%]",-1,-1,ylim = range (derep), xlim = c(1,20)) ##
polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)
#polygon(y = t(ans2[c(1,3),]), x = c(1:20, 20:1), col = 'green', border = NA)
#polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'blue', border = NA)
#polygon(y = t(ans4[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)

lines(ans1[2,],col='blue4',lty="dashed")
lines(ans2[2,],col='aquamarine4',lty="dashed")
lines(ans3[2,],col='brown1',lty="dashed")
lines(ans4[2,],col='darkorchid4',lty="dashed")
lines(derep, col = 'blue4', lwd=2)
lines(deugp, col = 'aquamarine4', lwd=2)
lines(dmirandap, col = 'brown1', lwd=2)
lines(dmojp, col = 'darkorchid4', lwd=2)
abline(v=5.5,lty="dashed")
abline(v=15.5,lty="dashed")

################# For Dere Deug  Dmiranda Dmoj non-syn
setwd("~/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dmel")

jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(m+c(-1, 0, 1)*s)) }

dat1 <- matrix(as.numeric(scan(file = 'Dere.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs1 = rowSums(dat1)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x/rs1) 
ans1 <- apply(X = tmp1, MARGIN = 2, FUN = jfunc)

dat2 <- matrix(as.numeric(scan(file = 'Deug.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs2 = rowSums(dat2)
tmp2 <- apply(X=dat2, MARGIN = 2, function(x) x/rs2) 
ans2 <- apply(X = tmp2, MARGIN = 2, FUN = jfunc)

dat3 <- matrix(as.numeric(scan(file = 'Dmiranda.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs3 = rowSums(dat3)
tmp3 <- apply(X=dat3, MARGIN = 2, function(x) x/rs3) 
ans3 <- apply(X= tmp3, MARGIN = 2, FUN = jfunc)

dat4 <- matrix(as.numeric(scan(file = 'Dmoj.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs4 = rowSums(dat4)
tmp4 <- apply(X=dat4, MARGIN = 2, function(x) x/rs4) 
ans4 <- apply(X = tmp4, MARGIN = 2, FUN = jfunc)


dere <- as.numeric(scan(file = 'Dere.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
derep <- dere/sum(dere)
deug <- as.numeric(scan(file = 'Deug.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
deugp <- deug/sum(deug)
dmiranda <- as.numeric(scan(file = 'Dmiranda.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dmirandap <- dmiranda/sum(dmiranda)
dmoj<- as.numeric(scan(file = 'Dmoj.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dmojp <- dmoj/sum(dmoj)

plot(xlab="D. melanogaster TAD",ylab="Syntenic or chromosomal arrangement breakpoints [%]",-1,-1,ylim = range (dmirandap), xlim = c(1,20)) ##
polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)
#polygon(y = t(ans2[c(1,3),]), x = c(1:20, 20:1), col = 'green', border = NA)
#polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'blue', border = NA)
#polygon(y = t(ans4[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)

lines(ans1[2,],col='blue4',lty="dashed")
lines(ans2[2,],col='aquamarine4',lty="dashed")
lines(ans3[2,],col='brown1',lty="dashed")
lines(ans4[2,],col='darkorchid4',lty="dashed")
lines(derep, col = 'blue4', lwd=2)
lines(deugp, col = 'aquamarine4', lwd=2)
lines(dmirandap, col = 'brown1', lwd=2)
lines(dmojp, col = 'darkorchid4', lwd=2)
abline(v=5.5,lty="dashed")
abline(v=15.5,lty="dashed")




### For D.tria D.bip D.pers D.wil


setwd("~/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dmel")

jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(m+c(-1, 0, 1)*s)) }

dat1 <- matrix(as.numeric(scan(file = 'Dtria.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs1 = rowSums(dat1)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x/rs1) 
ans1 <- apply(X = tmp1, MARGIN = 2, FUN = jfunc)

dat2 <- matrix(as.numeric(scan(file = 'Dbip.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs2 = rowSums(dat2)
tmp2 <- apply(X=dat2, MARGIN = 2, function(x) x/rs2) 
ans2 <- apply(X = tmp2, MARGIN = 2, FUN = jfunc)

dat3 <- matrix(as.numeric(scan(file = 'Dper.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs3 = rowSums(dat3)
tmp3 <- apply(X=dat3, MARGIN = 2, function(x) x/rs3) 
ans3 <- apply(X= tmp3, MARGIN = 2, FUN = jfunc)

dat4 <- matrix(as.numeric(scan(file = 'Dwil.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs4 = rowSums(dat4)
tmp4 <- apply(X=dat4, MARGIN = 2, function(x) x/rs4) 
ans4 <- apply(X = tmp4, MARGIN = 2, FUN = jfunc)


dtria <- as.numeric(scan(file = 'Dtria.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dtriap <- dtria/sum(dtria)
dbip <- as.numeric(scan(file = 'Dbip.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dbipp <- dbip/sum(dbip)
dper <- as.numeric(scan(file = 'Dper.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dperp <- dper/sum(dper)
dwil<- as.numeric(scan(file = 'Dwil.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dwilp <- dwil/sum(dwil)

plot(xlab="D. melanogaster TAD",ylab="Inversion breakpoints [%]",-1,-1,ylim = range(dbipp), xlim = c(1,20)) ##
polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)
#polygon(y = t(ans2[c(1,3),]), x = c(1:20, 20:1), col = 'green', border = NA)
#polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'blue', border = NA)
#polygon(y = t(ans4[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)

lines(ans1[2,],col='blue4',lty="dashed")
lines(ans2[2,],col='aquamarine4',lty="dashed")
lines(ans3[2,],col='brown1',lty="dashed")
lines(ans4[2,],col='darkorchid4',lty="dashed")
lines(dtriap, col = 'blue4', lwd=2)
lines(dbipp, col = 'aquamarine4', lwd=2)
lines(dperp, col = 'brown1', lwd=2)
lines(dwilp, col = 'darkorchid4', lwd=2)
abline(v=5.5,lty="dashed")
abline(v=15.5,lty="dashed")

#### For D.tria D.bip D.per D.will noninv



setwd("~/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dmel")

jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(m+c(-1, 0, 1)*s)) }

dat1 <- matrix(as.numeric(scan(file = 'Dtria.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs1 = rowSums(dat1)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x/rs1) 
ans1 <- apply(X = tmp1, MARGIN = 2, FUN = jfunc)

dat2 <- matrix(as.numeric(scan(file = 'Dbip.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs2 = rowSums(dat2)
tmp2 <- apply(X=dat2, MARGIN = 2, function(x) x/rs2) 
ans2 <- apply(X = tmp2, MARGIN = 2, FUN = jfunc)

dat3 <- matrix(as.numeric(scan(file = 'Dper.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs3 = rowSums(dat3)
tmp3 <- apply(X=dat3, MARGIN = 2, function(x) x/rs3) 
ans3 <- apply(X= tmp3, MARGIN = 2, FUN = jfunc)

dat4 <- matrix(as.numeric(scan(file = 'Dwil.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs4 = rowSums(dat4)
tmp4 <- apply(X=dat4, MARGIN = 2, function(x) x/rs4) 
ans4 <- apply(X = tmp4, MARGIN = 2, FUN = jfunc)


dtria <- as.numeric(scan(file = 'Dtria.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dtriap <- dtria/sum(dtria)
dbip <- as.numeric(scan(file = 'Dbip.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dbipp <- dbip/sum(dbip)
dper <- as.numeric(scan(file = 'Dper.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dperp <- dper/sum(dper)
dwil<- as.numeric(scan(file = 'Dwil.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dwilp <- dwil/sum(dwil)

plot(xlab="D. melanogaster TAD",ylab="Syntenic or chromosomal arrangement breakpoints [%]",-1,-1,ylim = range(dperp), xlim = c(1,20)) ##
polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)
#polygon(y = t(ans2[c(1,3),]), x = c(1:20, 20:1), col = 'green', border = NA)
#polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'blue', border = NA)
#polygon(y = t(ans4[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)

lines(ans1[2,],col='blue4',lty="dashed")
lines(ans2[2,],col='aquamarine4',lty="dashed")
lines(ans3[2,],col='brown1',lty="dashed")
lines(ans4[2,],col='darkorchid4',lty="dashed")
lines(dtriap, col = 'blue4', lwd=2)
lines(dbipp, col = 'aquamarine4', lwd=2)
lines(dperp, col = 'brown1', lwd=2)
lines(dwilp, col = 'darkorchid4', lwd=2)
abline(v=5.5,lty="dashed")
abline(v=15.5,lty="dashed")



### FigB For D.bia D.ana Dpseu and D.vir inversion

setwd("~/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dmel")

jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(m+c(-1, 0, 1)*s)) }

dat1 <- matrix(as.numeric(scan(file = 'Dbia.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs1 = rowSums(dat1)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x/rs1) 
ans1 <- apply(X = tmp1, MARGIN = 2, FUN = jfunc)

dat2 <- matrix(as.numeric(scan(file = 'Dana.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs2 = rowSums(dat2)
tmp2 <- apply(X=dat2, MARGIN = 2, function(x) x/rs2) 
ans2 <- apply(X = tmp2, MARGIN = 2, FUN = jfunc)

dat3 <- matrix(as.numeric(scan(file = 'Dpse.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs3 = rowSums(dat3)
tmp3 <- apply(X=dat3, MARGIN = 2, function(x) x/rs3) 
ans3 <- apply(X= tmp3, MARGIN = 2, FUN = jfunc)

dat4 <- matrix(as.numeric(scan(file = 'Dvir.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs4 = rowSums(dat4)
tmp4 <- apply(X=dat4, MARGIN = 2, function(x) x/rs4) 
ans4 <- apply(X = tmp4, MARGIN = 2, FUN = jfunc)


dbia <- as.numeric(scan(file = 'Dbia.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dbiap <- dbia/sum(dbia)
dana <- as.numeric(scan(file = 'Dana.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
danap <- dana/sum(dana)
dpse <- as.numeric(scan(file = 'Dpse.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dpsep <- dpse/sum(dpse)
dvir <- as.numeric(scan(file = 'Dvir.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dvirp <- dvir/sum(dvir)

plot(xlab="D. melanogaster TAD",ylab="Inversion breakpoints [%]",-1,-1,ylim = range(dpsep), xlim = c(1,20)) ##
polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)
#polygon(y = t(ans2[c(1,3),]), x = c(1:20, 20:1), col = 'green', border = NA)
#polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'blue', border = NA)
#polygon(y = t(ans4[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)

lines(ans1[2,],col='blue4',lty="dashed")
lines(ans2[2,],col='aquamarine4',lty="dashed")
lines(ans3[2,],col='brown1',lty="dashed")
lines(ans4[2,],col='darkorchid4',lty="dashed")
lines(dbiap, col = 'blue4', lwd=2)
lines(danap, col = 'aquamarine4', lwd=2)
lines(dpsep, col = 'brown1', lwd=2)
lines(dvirp, col = 'darkorchid4', lwd=2)
abline(v=5.5,lty="dashed")
abline(v=15.5,lty="dashed")



### Fig A For D.bia, D. ana, D. pseu, and D. vir Non-syn
setwd("~/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dmel")

jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(m+c(-1, 0, 1)*s)) }

dat1 <- matrix(as.numeric(scan(file = 'Dbia.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs1 = rowSums(dat1)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x/rs1) 
ans1 <- apply(X = tmp1, MARGIN = 2, FUN = jfunc)

dat2 <- matrix(as.numeric(scan(file = 'Dana.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs2 = rowSums(dat2)
tmp2 <- apply(X=dat2, MARGIN = 2, function(x) x/rs2) 
ans2 <- apply(X = tmp2, MARGIN = 2, FUN = jfunc)

dat3 <- matrix(as.numeric(scan(file = 'Dpse.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs3 = rowSums(dat3)
tmp3 <- apply(X=dat3, MARGIN = 2, function(x) x/rs3) 
ans3 <- apply(X= tmp3, MARGIN = 2, FUN = jfunc)

dat4 <- matrix(as.numeric(scan(file = 'Dvir.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs4 = rowSums(dat4)
tmp4 <- apply(X=dat4, MARGIN = 2, function(x) x/rs4) 
ans4 <- apply(X = tmp4, MARGIN = 2, FUN = jfunc)



dbia <- as.numeric(scan(file = 'Dbia.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dbiap <- dbia/sum(dbia)
dana <- as.numeric(scan(file = 'Dana.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
danap <- dana/sum(dana)
dpse <- as.numeric(scan(file = 'Dpse.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dpsep <- dpse/sum(dpse)
dvir <- as.numeric(scan(file = 'Dvir.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dvirp <- dvir/sum(dvir)

plot(xlab="D. melanogaster TAD",ylab="Syntenic or chromosomal arrangement breakpoints [%]",-1,-1,ylim = range(dpsep), xlim = c(1,20)) ##
polygon(y = t(ans1[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)
#polygon(y = t(ans2[c(1,3),]), x = c(1:20, 20:1), col = 'green', border = NA)
#polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'blue', border = NA)
#polygon(y = t(ans4[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)

lines(ans1[2,],col='blue4',lty="dashed")
lines(ans2[2,],col='aquamarine4',lty="dashed")
lines(ans3[2,],col='brown1',lty="dashed")
lines(ans4[2,],col='darkorchid4',lty="dashed")
lines(dbiap, col = 'blue4', lwd=2)
lines(danap, col = 'aquamarine4', lwd=2)
lines(dpsep, col = 'brown1', lwd=2)
lines(dvirp, col = 'darkorchid4', lwd=2)
abline(v=5.5,lty="dashed")
abline(v=15.5,lty="dashed")

















##########################################################################################################
############################################## Here below is for Dpse  ###################################
##########################################################################################################


#### For D.sec D. bia D. miranda D. persimilis 
setwd("~/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dpse")

jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(m+c(-1, 0, 1)*s)) }

dat1 <- matrix(as.numeric(scan(file = 'Dsec.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs1 = rowSums(dat1)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x/rs1) 
ans1 <- apply(X = tmp1, MARGIN = 2, FUN = jfunc)

dat2 <- matrix(as.numeric(scan(file = 'Dper.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs2 = rowSums(dat2)
tmp2 <- apply(X=dat2, MARGIN = 2, function(x) x/rs2) 
ans2 <- apply(X = tmp2, MARGIN = 2, FUN = jfunc)

dat3 <- matrix(as.numeric(scan(file = 'Dmiranda.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs3 = rowSums(dat3)
tmp3 <- apply(X=dat3, MARGIN = 2, function(x) x/rs3) 
ans3 <- apply(X= tmp3, MARGIN = 2, FUN = jfunc)

dat4 <- matrix(as.numeric(scan(file = 'Dbia.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs4 = rowSums(dat4)
tmp4 <- apply(X=dat4, MARGIN = 2, function(x) x/rs4) 
ans4 <- apply(X = tmp4, MARGIN = 2, FUN = jfunc)



dsec <- as.numeric(scan(file = 'Dsec.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dsecp <- dsec/sum(dsec)
dper <- as.numeric(scan(file = 'Dper.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dperp <- dper/sum(dper)
dmiranda <- as.numeric(scan(file = 'Dmiranda.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dmirandap <- dmiranda/sum(dmiranda)
dbia <- as.numeric(scan(file = 'Dbia.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dbiap <- dbia/sum(dbia)




plot(xlab="D. pseudoobscura TAD",ylab="Syntenic or chromosomal arrangement breakpoints [%]",-1,-1,ylim = range(dsecp), xlim = c(1,20)) ##


polygon(y = t(ans1[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)
#polygon(y = t(ans2[c(1,3),]), x = c(1:20, 20:1), col = 'green', border = NA)
#polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'blue', border = NA)
#polygon(y = t(ans4[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)

lines(ans1[2,],col='blue4',lty="dashed")
lines(ans2[2,],col='aquamarine4',lty="dashed")
lines(ans3[2,],col='brown1',lty="dashed")
lines(ans4[2,],col='darkorchid4',lty="dashed")
lines(dsecp, col = 'blue4', lwd=2)
lines(dperp, col = 'aquamarine4', lwd=2)
lines(dmirandap, col = 'brown1', lwd=2)
lines(dbiap, col = 'darkorchid4', lwd=2)
abline(v=5.5,lty="dashed")
abline(v=15.5,lty="dashed")

#### For Non inversions

###### For inversion
setwd("~/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dpse")

jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(m+c(-1, 0, 1)*s)) }

dat1 <- matrix(as.numeric(scan(file = 'Dsec.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs1 = rowSums(dat1)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x/rs1) 
ans1 <- apply(X = tmp1, MARGIN = 2, FUN = jfunc)

dat2 <- matrix(as.numeric(scan(file = 'Dper.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs2 = rowSums(dat2)
tmp2 <- apply(X=dat2, MARGIN = 2, function(x) x/rs2) 
ans2 <- apply(X = tmp2, MARGIN = 2, FUN = jfunc)

dat3 <- matrix(as.numeric(scan(file = 'Dmiranda.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs3 = rowSums(dat3)
tmp3 <- apply(X=dat3, MARGIN = 2, function(x) x/rs3) 
ans3 <- apply(X= tmp3, MARGIN = 2, FUN = jfunc)

dat4 <- matrix(as.numeric(scan(file = 'Dbia.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs4 = rowSums(dat4)
tmp4 <- apply(X=dat4, MARGIN = 2, function(x) x/rs4) 
ans4 <- apply(X = tmp4, MARGIN = 2, FUN = jfunc)



dsec <- as.numeric(scan(file = 'Dsec.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dsecp <- dsec/sum(dsec)
dper <- as.numeric(scan(file = 'Dper.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dperp <- dper/sum(dper)
dmiranda <- as.numeric(scan(file = 'Dmiranda.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dmirandap <- dmiranda/sum(dmiranda)
dbia <- as.numeric(scan(file = 'Dbia.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dbiap <- dbia/sum(dbia)




plot(xlab="D. pseudoobscura TAD",ylab="Inversion breakpoints [%]",-1,-1,ylim = range(dbiap), xlim = c(1,20)) ##


polygon(y = t(ans1[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)
#polygon(y = t(ans2[c(1,3),]), x = c(1:20, 20:1), col = 'green', border = NA)
#polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'blue', border = NA)
#polygon(y = t(ans4[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)

lines(ans1[2,],col='blue4',lty="dashed")
lines(ans2[2,],col='aquamarine4',lty="dashed")
lines(ans3[2,],col='brown1',lty="dashed")
lines(ans4[2,],col='darkorchid4',lty="dashed")
lines(dsecp, col = 'blue4', lwd=2)
lines(dperp, col = 'aquamarine4', lwd=2)
lines(dmirandap, col = 'brown1', lwd=2)
lines(dbiap, col = 'darkorchid4', lwd=2)
abline(v=5.5,lty="dashed")
abline(v=15.5,lty="dashed")










###############  For Dmau Deug D.tria D.will


###### For inversion
setwd("~/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dpse")

jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(m+c(-1, 0, 1)*s)) }

dat1 <- matrix(as.numeric(scan(file = 'Dmau.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs1 = rowSums(dat1)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x/rs1) 
ans1 <- apply(X = tmp1, MARGIN = 2, FUN = jfunc)

dat2 <- matrix(as.numeric(scan(file = 'Deug.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs2 = rowSums(dat2)
tmp2 <- apply(X=dat2, MARGIN = 2, function(x) x/rs2) 
ans2 <- apply(X = tmp2, MARGIN = 2, FUN = jfunc)

dat3 <- matrix(as.numeric(scan(file = 'Dtira.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs3 = rowSums(dat3)
tmp3 <- apply(X=dat3, MARGIN = 2, function(x) x/rs3) 
ans3 <- apply(X= tmp3, MARGIN = 2, FUN = jfunc)

dat4 <- matrix(as.numeric(scan(file = 'Dwil.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs4 = rowSums(dat4)
tmp4 <- apply(X=dat4, MARGIN = 2, function(x) x/rs4) 
ans4 <- apply(X = tmp4, MARGIN = 2, FUN = jfunc)



dmau <- as.numeric(scan(file = 'Dmau.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dmaup <- dmau/sum(dmau)
deug <- as.numeric(scan(file = 'Deug.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
deugp <- deug/sum(deug)
dtria <- as.numeric(scan(file = 'Dtria.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dtriap <- dtria/sum(dtria)
dwil <- as.numeric(scan(file = 'Dwil.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dwilp <- dwil/sum(dwil)




plot(xlab="D. pseudoobscura TAD",ylab="Inversion breakpoints [%]",-1,-1,ylim = range(deugp), xlim = c(1,20)) ##


polygon(y = t(ans1[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)
#polygon(y = t(ans2[c(1,3),]), x = c(1:20, 20:1), col = 'green', border = NA)
#polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'blue', border = NA)
#polygon(y = t(ans4[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)

lines(ans1[2,],col='blue4',lty="dashed")
lines(ans2[2,],col='aquamarine4',lty="dashed")
lines(ans3[2,],col='brown1',lty="dashed")
lines(ans4[2,],col='darkorchid4',lty="dashed")
lines(dmaup, col = 'blue4', lwd=2)
lines(deugp, col = 'aquamarine4', lwd=2)
lines(dtriap, col = 'brown1', lwd=2)
lines(dwilp, col = 'darkorchid4', lwd=2)
abline(v=5.5,lty="dashed")
abline(v=15.5,lty="dashed")




######For non inversion
setwd("~/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dpse")

jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(m+c(-1, 0, 1)*s)) }

dat1 <- matrix(as.numeric(scan(file = 'Dmau.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs1 = rowSums(dat1)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x/rs1) 
ans1 <- apply(X = tmp1, MARGIN = 2, FUN = jfunc)

dat2 <- matrix(as.numeric(scan(file = 'Deug.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs2 = rowSums(dat2)
tmp2 <- apply(X=dat2, MARGIN = 2, function(x) x/rs2) 
ans2 <- apply(X = tmp2, MARGIN = 2, FUN = jfunc)

dat3 <- matrix(as.numeric(scan(file = 'Dtira.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs3 = rowSums(dat3)
tmp3 <- apply(X=dat3, MARGIN = 2, function(x) x/rs3) 
ans3 <- apply(X= tmp3, MARGIN = 2, FUN = jfunc)

dat4 <- matrix(as.numeric(scan(file = 'Dwil.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs4 = rowSums(dat4)
tmp4 <- apply(X=dat4, MARGIN = 2, function(x) x/rs4) 
ans4 <- apply(X = tmp4, MARGIN = 2, FUN = jfunc)



dmau <- as.numeric(scan(file = 'Dmau.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dmaup <- dmau/sum(dmau)
deug <- as.numeric(scan(file = 'Deug.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
deugp <- deug/sum(deug)
dtria <- as.numeric(scan(file = 'Dtria.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dtriap <- dtria/sum(dtria)
dwil <- as.numeric(scan(file = 'Dwil.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dwilp <- dwil/sum(dwil)




plot(xlab="D. pseudoobscura TAD",ylab="Syntenic or chromosomal arrangement breakpoints [%]",-1,-1,ylim = range(dmaup), xlim = c(1,20)) ##


polygon(y = t(ans1[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)
#polygon(y = t(ans2[c(1,3),]), x = c(1:20, 20:1), col = 'green', border = NA)
#polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'blue', border = NA)
#polygon(y = t(ans4[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)

lines(ans1[2,],col='blue4',lty="dashed")
lines(ans2[2,],col='aquamarine4',lty="dashed")
lines(ans3[2,],col='brown1',lty="dashed")
lines(ans4[2,],col='darkorchid4',lty="dashed")
lines(dmaup, col = 'blue4', lwd=2)
lines(deugp, col = 'aquamarine4', lwd=2)
lines(dtriap, col = 'brown1', lwd=2)
lines(dwilp, col = 'darkorchid4', lwd=2)
abline(v=5.5,lty="dashed")
abline(v=15.5,lty="dashed")




###############For Dsim Dyak D.bip and D.moj
setwd("~/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dpse")

jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(m+c(-1, 0, 1)*s)) }

dat1 <- matrix(as.numeric(scan(file = 'Dsim.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs1 = rowSums(dat1)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x/rs1) 
ans1 <- apply(X = tmp1, MARGIN = 2, FUN = jfunc)

dat2 <- matrix(as.numeric(scan(file = 'Dyak.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs2 = rowSums(dat2)
tmp2 <- apply(X=dat2, MARGIN = 2, function(x) x/rs2) 
ans2 <- apply(X = tmp2, MARGIN = 2, FUN = jfunc)

dat3 <- matrix(as.numeric(scan(file = 'Dbip.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs3 = rowSums(dat3)
tmp3 <- apply(X=dat3, MARGIN = 2, function(x) x/rs3) 
ans3 <- apply(X= tmp3, MARGIN = 2, FUN = jfunc)

dat4 <- matrix(as.numeric(scan(file = 'Dmoj.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs4 = rowSums(dat4)
tmp4 <- apply(X=dat4, MARGIN = 2, function(x) x/rs4) 
ans4 <- apply(X = tmp4, MARGIN = 2, FUN = jfunc)



dsim <- as.numeric(scan(file = 'Dsim.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dsimp <- dsim/sum(dsim)
dyak <- as.numeric(scan(file = 'Dyak.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dyakp <- dyak/sum(dyak)
dbip <- as.numeric(scan(file = 'Dbip.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dbipp <- dbip/sum(dbip)
dmoj <- as.numeric(scan(file = 'Dmoj.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dmojp <- dmoj/sum(dmoj)




plot(xlab="D. pseudoobscura TAD",ylab="Syntenic or chromosomal arrangement breakpoints [%]",-1,-1,ylim = range(dsimp), xlim = c(1,20)) ##


polygon(y = t(ans1[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)
#polygon(y = t(ans2[c(1,3),]), x = c(1:20, 20:1), col = 'green', border = NA)
#polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'blue', border = NA)
#polygon(y = t(ans4[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)

lines(ans1[2,],col='blue4',lty="dashed")
lines(ans2[2,],col='aquamarine4',lty="dashed")
lines(ans3[2,],col='brown1',lty="dashed")
lines(ans4[2,],col='darkorchid4',lty="dashed")
lines(dsimp, col = 'blue4', lwd=2)
lines(dyakp, col = 'aquamarine4', lwd=2)
lines(dbipp, col = 'brown1', lwd=2)
lines(dmojp, col = 'darkorchid4', lwd=2)
abline(v=5.5,lty="dashed")
abline(v=15.5,lty="dashed")

####Inversion

setwd("~/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dpse")

jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(m+c(-1, 0, 1)*s)) }

dat1 <- matrix(as.numeric(scan(file = 'Dsim.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs1 = rowSums(dat1)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x/rs1) 
ans1 <- apply(X = tmp1, MARGIN = 2, FUN = jfunc)

dat2 <- matrix(as.numeric(scan(file = 'Dyak.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs2 = rowSums(dat2)
tmp2 <- apply(X=dat2, MARGIN = 2, function(x) x/rs2) 
ans2 <- apply(X = tmp2, MARGIN = 2, FUN = jfunc)

dat3 <- matrix(as.numeric(scan(file = 'Dbip.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs3 = rowSums(dat3)
tmp3 <- apply(X=dat3, MARGIN = 2, function(x) x/rs3) 
ans3 <- apply(X= tmp3, MARGIN = 2, FUN = jfunc)

dat4 <- matrix(as.numeric(scan(file = 'Dmoj.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs4 = rowSums(dat4)
tmp4 <- apply(X=dat4, MARGIN = 2, function(x) x/rs4) 
ans4 <- apply(X = tmp4, MARGIN = 2, FUN = jfunc)



dsim <- as.numeric(scan(file = 'Dsim.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dsimp <- dsim/sum(dsim)
dyak <- as.numeric(scan(file = 'Dyak.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dyakp <- dyak/sum(dyak)
dbip <- as.numeric(scan(file = 'Dbip.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dbipp <- dbip/sum(dbip)
dmoj <- as.numeric(scan(file = 'Dmoj.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dmojp <- dmoj/sum(dmoj)




plot(xlab="D. pseudoobscura TAD",ylab="Inversion breakpoints [%]",-1,-1,ylim = range(dmojp), xlim = c(1,20)) ##


polygon(y = t(ans1[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)
#polygon(y = t(ans2[c(1,3),]), x = c(1:20, 20:1), col = 'green', border = NA)
#polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'blue', border = NA)
#polygon(y = t(ans4[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)

lines(ans1[2,],col='blue4',lty="dashed")
lines(ans2[2,],col='aquamarine4',lty="dashed")
lines(ans3[2,],col='brown1',lty="dashed")
lines(ans4[2,],col='darkorchid4',lty="dashed")
lines(dsimp, col = 'blue4', lwd=2)
lines(dyakp, col = 'aquamarine4', lwd=2)
lines(dbipp, col = 'brown1', lwd=2)
lines(dmojp, col = 'darkorchid4', lwd=2)
abline(v=5.5,lty="dashed")
abline(v=15.5,lty="dashed")










#######################The below are for main figures

###############################Non-syntenic Pse


setwd("~/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dpse")

jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(m+c(-1, 0, 1)*s)) }

dat1 <- matrix(as.numeric(scan(file = 'Dmel.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs1 = rowSums(dat1)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x/rs1) 
ans1 <- apply(X = tmp1, MARGIN = 2, FUN = jfunc)

dat2 <- matrix(as.numeric(scan(file = 'Dere.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs2 = rowSums(dat2)
tmp2 <- apply(X=dat2, MARGIN = 2, function(x) x/rs2) 
ans2 <- apply(X = tmp2, MARGIN = 2, FUN = jfunc)

dat3 <- matrix(as.numeric(scan(file = 'Dana.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs3 = rowSums(dat3)
tmp3 <- apply(X=dat3, MARGIN = 2, function(x) x/rs3) 
ans3 <- apply(X= tmp3, MARGIN = 2, FUN = jfunc)

dat4 <- matrix(as.numeric(scan(file = 'Dvir.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs4 = rowSums(dat4)
tmp4 <- apply(X=dat4, MARGIN = 2, function(x) x/rs4) 
ans4 <- apply(X = tmp4, MARGIN = 2, FUN = jfunc)



dmel <- as.numeric(scan(file = 'Dmel.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dmelp <- dmel/sum(dmel)
dere <- as.numeric(scan(file = 'Dere.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
derep <- dere/sum(dere)
dana <- as.numeric(scan(file = 'Dana.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
danap <- dana/sum(dana)
dvir <- as.numeric(scan(file = 'Dvir.all.chain.filter.tnet.synnet.noninv.breaks.out.bed.sort.merge.actual.bed'))
dvirp <- dvir/sum(dvir)




plot(xlab="D. pseudoobscura TAD",ylab="Syntenic or chromosomal arrangement breakpoints [%]",-1,-1,ylim = range(dmelp), xlim = c(1,20)) ##


polygon(y = t(ans1[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)
#polygon(y = t(ans2[c(1,3),]), x = c(1:20, 20:1), col = 'green', border = NA)
#polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'blue', border = NA)
#polygon(y = t(ans4[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)

lines(ans1[2,],col='blue4',lty="dashed")
lines(ans2[2,],col='aquamarine4',lty="dashed")
lines(ans3[2,],col='brown1',lty="dashed")
lines(ans4[2,],col='darkorchid4',lty="dashed")
lines(dmelp, col = 'blue4', lwd=2)
lines(derep, col = 'aquamarine4', lwd=2)
lines(danap, col = 'brown1', lwd=2)
lines(dvirp, col = 'darkorchid4', lwd=2)
abline(v=5.5,lty="dashed")
abline(v=15.5,lty="dashed")


###############################Inversions Pse

setwd("~/Documents/2019_8_Paper_Final/BreakpointsSynteny/Dpse")

jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(m+c(-1, 0, 1)*s)) }

dat1 <- matrix(as.numeric(scan(file = 'Dmel.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs1 = rowSums(dat1)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x/rs1) 
ans1 <- apply(X = tmp1, MARGIN = 2, FUN = jfunc)

dat2 <- matrix(as.numeric(scan(file = 'Dere.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs2 = rowSums(dat2)
tmp2 <- apply(X=dat2, MARGIN = 2, function(x) x/rs2) 
ans2 <- apply(X = tmp2, MARGIN = 2, FUN = jfunc)

dat3 <- matrix(as.numeric(scan(file = 'Dana.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs3 = rowSums(dat3)
tmp3 <- apply(X=dat3, MARGIN = 2, function(x) x/rs3) 
ans3 <- apply(X= tmp3, MARGIN = 2, FUN = jfunc)

dat4 <- matrix(as.numeric(scan(file = 'Dvir.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.background.bed')), nc = 20)
rs4 = rowSums(dat4)
tmp4 <- apply(X=dat4, MARGIN = 2, function(x) x/rs4) 
ans4 <- apply(X = tmp4, MARGIN = 2, FUN = jfunc)



dmel <- as.numeric(scan(file = 'Dmel.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dmelp <- dmel/sum(dmel)
dere <- as.numeric(scan(file = 'Dere.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
derep <- dere/sum(dere)
dana <- as.numeric(scan(file = 'Dana.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
danap <- dana/sum(dana)
dvir <- as.numeric(scan(file = 'Dvir.all.chain.filter.tnet.synnet.inv.breaks.out.bed.sort.merge.actual.bed'))
dvirp <- dvir/sum(dvir)




plot(xlab="D. pseudoobscura TAD",ylab="Inversion breakpoints [%]",-1,-1,ylim = range(danap), xlim = c(1,20)) ##Syntenic or chromosomal arrangement breakpoints


polygon(y = t(ans1[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)
#polygon(y = t(ans2[c(1,3),]), x = c(1:20, 20:1), col = 'green', border = NA)
#polygon(y = t(ans3[c(1,3),]), x = c(1:20, 20:1), col = 'blue', border = NA)
#polygon(y = t(ans4[c(1,3),]), x = c(1:20, 20:1), col = 'gray', border = NA)

lines(ans1[2,],col='blue4',lty="dashed")
lines(ans2[2,],col='aquamarine4',lty="dashed")
lines(ans3[2,],col='brown1',lty="dashed")
lines(ans4[2,],col='darkorchid4',lty="dashed")
lines(dmelp, col = 'blue4', lwd=2)
lines(derep, col = 'aquamarine4', lwd=2)
lines(danap, col = 'brown1', lwd=2)
lines(dvirp, col = 'darkorchid4', lwd=2)
abline(v=5.5,lty="dashed")
abline(v=15.5,lty="dashed")
