library(dplyr)
library(ggplot2)
library(gridExtra)

install.packages("ggpubr")
library("ggpubr")
setwd("/Users/yiliao/Projects/2020TAD_revision/TADsize")

dif1<-read.table ("dif.density.txt",sep="\t",header=FALSE)
x<-dif1[,1]

h<-hist(x, breaks=80, col="red", plot=FALSE)
cuts<-cut(h$breaks,c(-Inf,1,Inf))
plot(h,col=cuts,xlab="Difference in orthologous TAD size")

xfit<-seq(min(x),max(x),length=40)
yfit<-dnorm(xfit,mean=mean(x),sd=sd(x))
yfit <- yfit*diff(h$mids[1:2])*length(x)
lines(xfit, yfit, col="green", lwd=2)

df2 <-read.table ("DpsevsDmel.TAD.size.419.bed",sep="\t",header=TRUE)
ggscatter(df2, x = "A", y = "B", 
          add = "reg.line", conf.int = TRUE, 
          cor.coef = TRUE, cor.method = "pearson",
          xlab = "Dpse TAD sizes", ylab = "Dmel TAD sizes")

df3 <- read.table ("sizedifVSsyndif.bed.bed",sep="\t",header=TRUE) 
ggscatter(df3, x = "A", y = "B", 
          add = "reg.line", conf.int = TRUE, 
          cor.coef = TRUE, cor.method = "pearson",
          xlab = "Dif. in TAD size", ylab = "Dif. in syntenic block size")






