setwd("/home/yiliao/Documents/20200905GRrevision/TAD_annotation/CTCF")

### For CTCF
CTCF <-read.table("CTCF.40k.final.list")
colnames(CTCF)<-c("label","counts")
CTCFmean<-sum(CTCF[,2])/81
CTCF$counts <- CTCF$counts/CTCFmean 
jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(1+c(-1, 0, 1)*s/m)) }
dat1 <- matrix(as.numeric(scan(file = 'CTCF.simulate.txt')), nc = 81)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x) 
ans1 <- apply(X=tmp1, MARGIN = 2, FUN = jfunc)

plot(xlab="Distance to TAD boundary",ylab="Fold enrichment",41,27, ylim = c(0,5), xlim = c(0,81))  
polygon(y = t(ans1[c(1,3),]), x = c(1:81, 81:1), col = 'gray', border = NA)
lines(ans1[2,],col='blue4',lty="dashed")
lines(CTCF$label+41,CTCF$counts,col = 'black', lwd=2)

### For BEAF-32
BEAF <-read.table("BEAF.40k.final.list")
colnames(BEAF)<-c("label","counts")
BEAFmean<-sum(BEAF[,2])/81
BEAF$counts <- BEAF$counts/BEAFmean 
jfunc <- function(x) { s <- sd(x); m <- mean(x); return(c(1+c(-1, 0, 1)*s/m)) }
dat1 <- matrix(as.numeric(scan(file = 'BEAF.simulate.txt')), nc = 81)
tmp1 <- apply(X=dat1, MARGIN = 2, function(x) x) 
ans1 <- apply(X=tmp1, MARGIN = 2, FUN = jfunc)

plot(xlab="Distance to TAD boundary",ylab="Fold enrichment",41,27, ylim = c(0,4), xlim = c(0,81))  
polygon(y = t(ans1[c(1,3),]), x = c(1:81, 81:1), col = 'gray', border = NA)
lines(ans1[2,],col='blue4',lty="dashed")
lines(BEAF$label+41,BEAF$counts,col = 'black', lwd=2)

### For H3K4
H3K4 <-read.table("H3K4.simulate.txt.txt.txt")
colnames(H3K4)<-c("label","counts")
plot(xlab="Distance to TAD boundary (kb)",ylab="log2(ChIP/Input)",100,100, ylim=c(-1.0,0.5), xlim = c(-42,42) )
A<-rep (c(-0.6564,-0.7710), each=85)
polygon(y = c(A), x = c(-42:42, 42:-42), col = 'gray', border = NA)
B<-rep(c(-0.715), each=85 )
lines(y=c(B),x=(-42:42),col='blue4',lty="dashed")
lines(H3K4$label,H3K4$counts,col = 'black', lwd=2)

### For H3K27
H3K27 <-read.table("H3K27.simulate.txt.txt.txt")
colnames(H3K27)<-c("label","counts")
plot(xlab="Distance to TAD boundary (kb)",ylab="log2(ChIP/Input)",100,100, ylim=c(-1.0,0.5), xlim = c(-42,42) )
A<-rep (c(-0.2742,-0.1506), each=85)
polygon(y = c(A), x = c(-42:42, 42:-42), col = 'gray', border = NA)
B<-rep(c(-0.21235), each=85 )
lines(y=c(B),x=(-42:42),col='blue4',lty="dashed")
lines(H3K27$label,H3K27$counts,col = 'black', lwd=2)

### For ATAC
ATAC <-read.table("ATAC.simulate.txt.txt.txt")
colnames(ATAC)<-c("label","counts")
plot(xlab="Distance to TAD boundary (kb)",ylab="Read count",100,100, ylim=c(4,12), xlim = c(-42,42) )
A<-rep (c(5.4543,6.6383), each=85)
polygon(y = c(A), x = c(-42:42, 42:-42), col = 'gray', border = NA)
B<-rep(c(6.0204), each=85 )
lines(y=c(B),x=(-42:42),col='blue4',lty="dashed")
lines(ATAC$label,ATAC$counts,col = 'black', lwd=2)
