
library(edgeR)
library(gplots)
# Read in alleleic read counts
data.lat<-P.latAlleleCount
data.mex<-P.mexAlleleCount
# Read in transcript length
lat.allele.length<-P.latAlleleTranscriptLength
mex.allele.length<-P.mexAlleleTranscriptLength
# Read in total gene expression
total.exp<-FeatureCount_TotalExpression_CountTable
# Normalize allelic counts and calculate allelic experssion using allelic counts
lat.adjusted<-data.lat
lat.adjusted<-matrix(rep(0, dim(lat.adjusted)[1]*dim(lat.adjusted)[2]), ncol = dim(lat.adjusted)[2])
mex.adjusted<-data.mex
mex.adjusted<-matrix(rep(0, dim(mex.adjusted)[1]*dim(mex.adjusted)[2]), ncol = dim(mex.adjusted)[2])

for (i in 1: dim(total.exp)[1]){
    for (j in 1:dim(total.exp)[2]){
		
        if (total.exp[i,j]==0){      # if total gene expression is 0, then both alleles are 0;
            lat.adjusted[i,j]<-0
            mex.adjusted[i,j]<-0
        }
        
        
        if (total.exp[i,j]!=0){     # if both allele show 0, but total gene is expressed, means no SNP, assuming equal contribution;
            if(molly.lat[i,j]==0){
                if(molly.mex[i,j]==0){
                    lat.adjusted[i,j]<-total.exp[i,j]*0.5
                    mex.adjusted[i,j]<-total.exp[i,j]*0.5
                }
            
            }
        }
        
        
        if (total.exp[i,j]!=0){     # monoallelic expression
            if(molly.lat[i,j]==0){
                if(molly.mex[i,j]!=0){
                    lat.adjusted[i,j]<-0
                    mex.adjusted[i,j]<-total.exp[i,j]
                }
                
            }
        }
        
        if (total.exp[i,j]!=0){    # monoallelic expression
            if(molly.lat[i,j]!=0){
                if(molly.mex[i,j]==0){
                    lat.adjusted[i,j]<-total.exp[i,j]
                    mex.adjusted[i,j]<-0
                }
                
            }
        }
        
        if (total.exp[i,j]!=0){     # calculate length normalized allelic expression
            if(molly.lat[i,j]!=0){
                if(molly.mex[i,j]!=0){
                    lat.adjusted[i,j]<-total.exp[i,j] * ((molly.lat[i,j]/lat.allele.length[i,1])/((molly.lat[i,j]/lat.allele.length[i,1])+(molly.mex[i,j]/mex.allele.length[i,1])))
                    mex.adjusted[i,j]<-total.exp[i,j] * ((molly.mex[i,j]/mex.allele.length[i,1])/((molly.lat[i,j]/lat.allele.length[i,1])+(molly.mex[i,j]/mex.allele.length[i,1])))
                }
                
            }
        
        }
    
    
    
    
    }
    
}
lat.adjusted<-round(lat.adjusted,1)
mex.adjusted<-round(mex.adjusted,1)

# calculate allele length ratio and only do analyses on the genes that do not show large differences between ancestral alleles.
length.ratio<-as.matrix(lat.allele.length[,1]/mex.allele.length[,1])
colnames(length.ratio)[1]<-"length.ratio"
length.ratio<-as.matrix(length.ratio[((length.ratio[,"length.ratio"]<=2) & (length.ratio[,"length.ratio"]>=0.5)),])
colnames(length.ratio)[1]<-"length.ratio"
# total of 22118 alleles;
# after length filter: 21119 alleles
lat.adjusted<-lat.adjusted[rownames(length.ratio),]
mex.adjusted<-mex.adjusted[rownames(length.ratio),]



# chi.sq test for allelic bias
for (x in 1:dim(lat.over.mex)[1]){
	for (y in 1:dim(lat.over.mex)[2]){
		p.value<-chisq.test(c(lat.adjusted[x,y]+0.01, mex.adjusted[x,y]+0.01))$p.value
		ratio<-lat.over.mex[x,y]
		if (p.value>=0.05 | (ratio>=-0.27 & ratio<=0.27)){       #2^0.27 ~= 1.2
		  lat.over.mex[x,y]<-0
		  }
	}
}













