# Heatshock

## Compare TSA-Seq datasets from different heat shock conditions or biological replicates
Use the 20kb-binned TSA-Seq_hanning_20kbx21.wig files generated from the "Smooth" step to compare SON TSA-Seq datasets from two heat shock conditons (different heat shock time points vs no heat shock control) or from two biological replicates.

e.g.:

```shell
python TSAScore_correlation_v3_color_hist2d_TSA2.0.py -w1 NHS_TSA-Seq_hanning_20kbx21.wig -w2 HS30min_TSA-Seq_hanning_20kbx21.wig -x no_heat_shock_control -y heat_shock_30min -o NHS_HS30min_2D_histogram.eps
```
This code will generate a genome-wide 2D histogram showing smoothed TSA-Seq score (20kb bin) correlation from the two datasets with color-coded number of bins (NHS_HS30min_2D_histogram.eps). 

This code will also report the Pearson product-moment correlation coefficient (Pearson's r) of the correlation.

Supplementary Figure 10C was generated by this code.

## Identify changed domains between two heatshock conditions (heat shock 30min vs no heat shock control)
See the "TSA-Seq-2020v2/Changed_Region" folder for codes.
