## TSA-seq 2.0 processing code

## Introduction

This repo hosts the pipeline for normalizing TSA-seq data generated by TSA-seq 2.0 paper. Compared with the normalization step used in the TSA-seq 1.0 paper, we made several important modifications (see below). Other codes used for the TSA-seq 2.0 paper can be accessed at [TSA-seq 2.0 code repo](https://github.com/lgchang27/TSA-Seq-2020)

The codes have been tested under:

- Python (tested in Python 2.7)
- argparse
- numpy
- pysam

## Reads mapping

The pipeline does not have any requirement of read mapping procedure. It begins with bam file. For read mapping, any well-known mapping tools such as Bowtie, BWA and SOAP2 can be used. We do suggest to remove PCR duplicates after the mapping process, and bam file should be sorted and indexed. For example, in the paper we used the following code to map reads to human genome and generate bam files

```shell
# Since K562 is derived from a female, we remove chromosome Y from human reference genome hg19 and named it hg19F
bowtie2 -p 8 -x hg19F -U SON_TSA-seq_pulldown.fastq -S SON_TSA-seq_pulldown.sam

# Convert Sam to Bam
samtools view -bS SON_TSA-seq_pulldown.sam > SON_TSA-seq_pulldown.bam

# You can also combine the above two steps if you do not want to save sam file on the disk using
# bowtie2 -p 8 -x hg19F -U SON_TSA-seq_pulldown.fastq | samtools view -bS - > SON_TSA-seq_pulldown.bam

# Sort bam file
samtools sort SON_TSA-seq_pulldown.bam SON_TSA-seq_pulldown_sort

# remove pcr duplicate from bam file
samtools rmdup SON_TSA-seq_pulldown_sort SON_TSA-seq_pulldown_rmdup.bam

# Index bam file
samtools index SON_TSA-seq_pulldown_rmdup.bam
```
## Normalization

The new version of normalization code is modified based on the previous version of [normalization script](../TSA-seq_1.0/README.md). Specifically, we improved our pipeline in two directions. First, we now use non-overlapping genomic bins inteading sliding windows with step. In the TSA-seq 2.0 paper, we chose genomic bin size as 20kb. Each mapped read is exclusively assigned to one genomic bin according to its largest aligned position. Second, we adopted a new formula to calculate the TSA-seq enrichment score (a.k.a TSA-seq score). Briefly, we firstly calculate input coverage normalized read count for each bin, noted N-norm. We then divide N-norm with the genomic average of N-norm (regions with no read mapped in the input sample are removed for this calculation) and define the ratio as the new TSA-seq enrichment score. For details of the method, please refer to the supplementary methods in the TSA-seq 2.0 paper.

```shell
# Normalize SON TSA-seq pulldown with matched input
python Norma_TSA-seq_2.0.py -r 20000 -w 20000 -e SON_TSA-seq_pulldown_rmdup.bam -c SON_TSA-seq_pulldown_input_rmdump.bam -g hg39.genome --output K562_SON_TSA-seq --wig2bw /usr/bin/wigToBigWig

# the meaning the of parameters are shown below:
# -r => size of genomic bin in base pair (bp)
# -w => size of step, Notably, here we choose r and w both equal to 20000 so that adjacent genomic bins will not overlap with each other, i.e. we cut the genome into consecutive and non-overlapping bins
# -e => bam file for pulldown sample
# -c => bam file for matched input sample
# -o => output file prefix
# --wig2bw => path to the binary program of wigToBigWig, you can use put 'sys' here if wigToBigWig is available in your PATH environment
```
The normalization step will generate one output file. One for the normalized TSA-seq score. The other two wig files show the signal profiles for pulldown sample and input sample under the resolution defined by -N and -r.

## About

The code for processing TSA-seq data is authored and maintained by [Yang Zhang](mailto:yangz6@andrew.cmu.edu)

## Cite

To cite TSA-seq 2.0 paper, use the following information.
```
@article{zhang2019tsa,
  title={TSA-Seq 2.0 reveals both conserved and variable chromosomal distances to nuclear speckles},
  author={Zhang, Liguo and Zhang, Yang and Chen, Yu and Gholamalamdari, Omid and Ma, Jian and Belmont, Andrew S},
  journal={bioRxiv},
  pages={824433},
  year={2019},
  publisher={Cold Spring Harbor Laboratory}
}
```
