/* eslint-env jest */
/**
 * @fileoverview Enforce <marquee> elements are not used.
 * @author Ethan Cohen
 */

// -----------------------------------------------------------------------------
// Requirements
// -----------------------------------------------------------------------------

import { RuleTester } from 'eslint';
import parserOptionsMapper from '../../__util__/parserOptionsMapper';
import rule from '../../../src/rules/accessible-emoji';

// -----------------------------------------------------------------------------
// Tests
// -----------------------------------------------------------------------------

const ruleTester = new RuleTester();

const expectedError = {
  message: 'Emojis should be wrapped in <span>, have role="img", and have an accessible description with aria-label or aria-labelledby.',
  type: 'JSXOpeningElement',
};

ruleTester.run('accessible-emoji', rule, {
  valid: [
    { code: '<div />;' },
    { code: '<span />' },
    { code: '<span>No emoji here!</span>' },
    { code: '<span role="img" aria-label="Panda face">🐼</span>' },
    { code: '<span role="img" aria-label="Snowman">&#9731;</span>' },
    { code: '<span role="img" aria-labelledby="id1">🐼</span>' },
    { code: '<span role="img" aria-labelledby="id1">&#9731;</span>' },
    { code: '<span role="img" aria-labelledby="id1" aria-label="Snowman">&#9731;</span>' },
    { code: '<span>{props.emoji}</span>' },
  ].map(parserOptionsMapper),
  invalid: [
    { code: '<span>🐼</span>', errors: [expectedError] },
    { code: '<span>foo🐼bar</span>', errors: [expectedError] },
    { code: '<span>foo 🐼 bar</span>', errors: [expectedError] },
    { code: '<i role="img" aria-label="Panda face">🐼</i>', errors: [expectedError] },
    { code: '<i role="img" aria-labelledby="id1">🐼</i>', errors: [expectedError] },
    { code: '<Foo>🐼</Foo>', errors: [expectedError] },
  ].map(parserOptionsMapper),
});
