# simulateNGSMix

## Getting started
simulateNGSMix is a bash-script that creates in-silico mixtures of 2 input samples. As an input, 2 FASTA files together with a NGS sequencing device name is required. It produces mixed BAM files of the 2 input samples that are ready to be evaluated with haplocheck. 

## Prerequisites 

The bash script relies on 3 different tools:

1. [ART NGS Read simulator](https://www.niehs.nih.gov/research/resources/software/biostatistics/art/index.cfm)
     (Ubuntu: ```sudo apt-get install art-nextgen-simulation-tools```)
2. [Samtools](http://samtools.github.io)
3. [BWA MEM](https://github.com/lh3/bwa)

### Optional 
Adapt reference file in bash script, if other than provided:    ```PATHBWAINDEX="/ref/chrM.fasta"```
    
Adapt output folder, default folder called: out    ```OUTPUTFOLDER="out"```    
    

## Run 
### Generate a mixture 
```sh
# for generating HiSeq 2500 data:
sh simulateNGSMix data/Lab011.fasta data/Lab002.fasta HS25

# for generating MiSeq v3 data:
sh simulateNGSMix data/Lab011.fasta data/Lab002.fasta MSv3
```
### Run haplocheck - either through mutserve or haplocheck

```sh
#Run mutserve by adapting parameters on your own, e.g. here level to 0.004 in order to go down the 0.5% mixtures
java -jar -Xmx8G mutserve-1.3.1.jar analyse-local --input data --alignQ 30 --mapQ 30 --level 0.004 --noBaq --reference ref/chrM.fasta --output simulatedNGSMix.vcf

#Run haplocheck on all BAM files from folder data
./cloudgene run haplocheck@1.1.2 --files data --output Result.vcf  
```

### Mitoverse: 
 - Upload VCF generated by mutserve to https://mitoverse.i-med.ac.at/index.html
 - Or upload the BAM file from simulateNGSMix directly to https://mitoverse.i-med.ac.at/index.html



