/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;

public class WrapSeekable<S extends InputStream>
extends SeekableStream {
    private final S stm;
    private final long len;
    private final Path path;

    public WrapSeekable(S s, long length, Path p) {
        this.stm = s;
        this.len = length;
        this.path = p;
    }

    public static WrapSeekable<FSDataInputStream> openPath(FileSystem fs, Path p) throws IOException {
        return new WrapSeekable<FSDataInputStream>(fs.open(p), fs.getFileStatus(p).getLen(), p);
    }

    public static WrapSeekable<FSDataInputStream> openPath(Configuration conf, Path path) throws IOException {
        return WrapSeekable.openPath(path.getFileSystem(conf), path);
    }

    @Override
    public String getSource() {
        return this.path.toString();
    }

    @Override
    public long length() {
        return this.len;
    }

    @Override
    public long position() throws IOException {
        return ((Seekable)this.stm).getPos();
    }

    @Override
    public void close() throws IOException {
        ((InputStream)this.stm).close();
    }

    @Override
    public boolean eof() throws IOException {
        return ((Seekable)this.stm).getPos() == this.length();
    }

    @Override
    public void seek(long pos) throws IOException {
        ((Seekable)this.stm).seek(pos);
    }

    @Override
    public int read() throws IOException {
        return ((InputStream)this.stm).read();
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        return ((InputStream)this.stm).read(buf, offset, len);
    }
}

