/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.AsciiLineReaderIterator;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.variant.bcf2.BCF2Codec;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.seqdoop.hadoop_bam.VCFFormat;

public final class VCFHeaderReader {
    public static VCFHeader readHeaderFrom(SeekableStream in) throws IOException {
        FeatureCodecHeader headerCodec = null;
        Object header = null;
        long initialPos = in.position();
        try {
            BufferedInputStream bis = new BufferedInputStream(in);
            FilterInputStream is = VCFFormat.isGzip(bis) ? new GZIPInputStream(bis) : bis;
            headerCodec = new VCFCodec().readHeader(new AsciiLineReaderIterator(new AsciiLineReader(is)));
        }
        catch (TribbleException e) {
            System.err.println("warning: while trying to read VCF header from file received exception: " + e.toString());
            in.seek(initialPos);
            InputStream bin = new BufferedInputStream(in);
            if (BlockCompressedInputStream.isValidFile(bin)) {
                bin = new BlockCompressedInputStream(bin);
            }
            headerCodec = new BCF2Codec().readHeader(new PositionalBufferedStream(bin));
        }
        if (!(headerCodec instanceof FeatureCodecHeader)) {
            throw new IOException("No VCF header found");
        }
        header = headerCodec.getHeaderValue();
        return (VCFHeader)header;
    }
}

