/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.ref.ReferenceSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;

public final class SAMHeaderReader {
    public static final String VALIDATION_STRINGENCY_PROPERTY = "hadoopbam.samheaderreader.validation-stringency";

    public static SAMFileHeader readSAMHeaderFrom(Path path, Configuration conf) throws IOException {
        FSDataInputStream i = path.getFileSystem(conf).open(path);
        SAMFileHeader h = SAMHeaderReader.readSAMHeaderFrom((InputStream)i, conf);
        i.close();
        return h;
    }

    public static SAMFileHeader readSAMHeaderFrom(InputStream in, Configuration conf) {
        ReferenceSource refSource;
        ValidationStringency stringency = SAMHeaderReader.getValidationStringency(conf);
        SamReaderFactory readerFactory = SamReaderFactory.makeDefault().setOption(SamReaderFactory.Option.EAGERLY_DECODE, false).setUseAsyncIo(false);
        if (stringency != null) {
            readerFactory.validationStringency(stringency);
        }
        if (null != (refSource = SAMHeaderReader.getReferenceSource(conf))) {
            readerFactory.referenceSource(refSource);
        }
        return readerFactory.open(SamInputResource.of(in)).getFileHeader();
    }

    public static ValidationStringency getValidationStringency(Configuration conf) {
        String p = conf.get(VALIDATION_STRINGENCY_PROPERTY);
        return p == null ? null : ValidationStringency.valueOf(p);
    }

    public static ReferenceSource getReferenceSource(Configuration conf) {
        String refSourcePath = conf.get("hadoopbam.cram.reference-source-path");
        return refSourcePath == null ? null : new ReferenceSource(Paths.get(URI.create(refSourcePath)));
    }
}

