/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import com.google.common.io.CountingOutputStream;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.seqdoop.hadoop_bam.SAMFormat;
import org.seqdoop.hadoop_bam.SplittingBAMIndex;
import org.seqdoop.hadoop_bam.SplittingBAMIndexer;
import org.seqdoop.hadoop_bam.util.NIOFileUtil;
import org.seqdoop.hadoop_bam.util.SAMOutputPreparer;

public class SAMFileMerger {
    private SAMFileMerger() {
    }

    public static void mergeParts(String partDirectory, String outputFile, SAMFormat samOutputFormat, SAMFileHeader header) throws IOException {
        long headerLength;
        Path outputPath;
        String successFile = partDirectory + "/_SUCCESS";
        Path successPath = NIOFileUtil.asPath(successFile);
        if (!Files.exists(successPath, new LinkOption[0])) {
            throw new NoSuchFileException(successFile, null, "Unable to find _SUCCESS file");
        }
        Path partPath = NIOFileUtil.asPath(partDirectory);
        if (partPath.equals(outputPath = NIOFileUtil.asPath(outputFile))) {
            throw new IllegalArgumentException("Cannot merge parts into output with same path: " + partPath);
        }
        List<Path> parts = NIOFileUtil.getFilesMatching(partPath, "glob:**/part-[mr]-[0-9][0-9][0-9][0-9][0-9]*", ".splitting-bai");
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("Could not write bam file because no part files were found in " + partPath);
        }
        Files.deleteIfExists(outputPath);
        try (CountingOutputStream out = new CountingOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
            if (header != null) {
                new SAMOutputPreparer().prepareForRecords((OutputStream)out, samOutputFormat, header);
            }
            headerLength = out.getCount();
            NIOFileUtil.mergeInto(parts, (OutputStream)out);
            SAMFileMerger.writeTerminatorBlock((OutputStream)out, samOutputFormat);
        }
        long fileLength = Files.size(outputPath);
        Path outputSplittingBaiPath = outputPath.resolveSibling(outputPath.getFileName() + ".splitting-bai");
        Files.deleteIfExists(outputSplittingBaiPath);
        try (OutputStream out = Files.newOutputStream(outputSplittingBaiPath, new OpenOption[0]);){
            SAMFileMerger.mergeSplittingBaiFiles(out, partPath, headerLength, fileLength);
        }
        catch (IOException e) {
            NIOFileUtil.deleteRecursive(outputSplittingBaiPath);
            throw e;
        }
        NIOFileUtil.deleteRecursive(partPath);
    }

    private static void writeTerminatorBlock(OutputStream out, SAMFormat samOutputFormat) throws IOException {
        if (SAMFormat.CRAM == samOutputFormat) {
            CramIO.issueEOF((Version)CramVersions.DEFAULT_CRAM_VERSION, (OutputStream)out);
        } else {
            out.write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
        }
    }

    static void mergeSplittingBaiFiles(OutputStream out, Path directory, long headerLength, long fileLength) throws IOException {
        List<Path> parts = NIOFileUtil.getFilesMatching(directory, "glob:**/part-[mr]-[0-9][0-9][0-9][0-9][0-9]*.splitting-bai", null);
        if (parts.isEmpty()) {
            return;
        }
        ArrayList<Long> mergedVirtualOffsets = new ArrayList<Long>();
        long partFileOffset = headerLength;
        for (Path path : parts) {
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            Throwable throwable = null;
            try {
                SplittingBAMIndex index = new SplittingBAMIndex(in);
                LinkedList<Long> virtualOffsets = new LinkedList<Long>(index.getVirtualOffsets());
                for (int i = 0; i < virtualOffsets.size() - 1; ++i) {
                    long virtualOffset = virtualOffsets.get(i);
                    mergedVirtualOffsets.add(SAMFileMerger.shiftVirtualFilePointer(virtualOffset, partFileOffset));
                }
                long partLength = virtualOffsets.getLast();
                partFileOffset += partLength >> 16;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                in.close();
            }
        }
        SplittingBAMIndexer splittingBAMIndexer = new SplittingBAMIndexer(out);
        for (Long offset : mergedVirtualOffsets) {
            splittingBAMIndexer.writeVirtualOffset(offset);
        }
        splittingBAMIndexer.finish(partFileOffset);
        int n = BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK.length;
        if (partFileOffset + (long)n != fileLength) {
            throw new IOException("Part file length mismatch. Last part file offset is " + partFileOffset + ", expected: " + (fileLength - (long)n));
        }
        for (Path part : parts) {
            Files.delete(part);
        }
    }

    private static long shiftVirtualFilePointer(long virtualFilePointer, long offset) {
        long blockAddress = BlockCompressedFilePointerUtil.getBlockAddress(virtualFilePointer);
        int blockOffset = BlockCompressedFilePointerUtil.getBlockOffset(virtualFilePointer);
        return blockAddress + offset << 16 | (long)blockOffset;
    }
}

