/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class NIOFileUtil {
    public static final String PARTS_GLOB = "glob:**/part-[mr]-[0-9][0-9][0-9][0-9][0-9]*";

    private NIOFileUtil() {
    }

    public static Path asPath(String path) {
        URI uri = URI.create(path);
        return uri.getScheme() == null ? Paths.get(path, new String[0]) : Paths.get(uri);
    }

    public static void deleteRecursive(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static List<Path> getFilesMatching(Path directory, String syntaxAndPattern, String excludesExt) throws IOException {
        PathMatcher matcher = directory.getFileSystem().getPathMatcher(syntaxAndPattern);
        List<Path> parts = Files.walk(directory, new FileVisitOption[0]).filter(matcher::matches).filter(path -> excludesExt == null || !path.toString().endsWith(excludesExt)).collect(Collectors.toList());
        Collections.sort(parts);
        return parts;
    }

    public static void mergeInto(List<Path> parts, OutputStream out) throws IOException {
        for (Path part : parts) {
            Files.copy(part, out);
        }
        for (Path part : parts) {
            Files.delete(part);
        }
    }
}

