/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.seqdoop.hadoop_bam.util.BGZFSplitCompressionInputStream;
import org.seqdoop.hadoop_bam.util.BGZFSplitGuesser;

public class BGZFEnhancedGzipCodec
extends GzipCodec
implements SplittableCompressionCodec {
    public SplitCompressionInputStream createInputStream(InputStream seekableIn, Decompressor decompressor, long start, long end, SplittableCompressionCodec.READ_MODE readMode) throws IOException {
        if (!(seekableIn instanceof Seekable)) {
            throw new IOException("seekableIn must be an instance of " + Seekable.class.getName());
        }
        if (!BlockCompressedInputStream.isValidFile(new BufferedInputStream(seekableIn))) {
            ((Seekable)seekableIn).seek(0L);
            final CompressionInputStream compressionInputStream = this.createInputStream(seekableIn, decompressor);
            return new SplitCompressionInputStream((InputStream)compressionInputStream, start, end){

                public int read(byte[] b, int off, int len) throws IOException {
                    return compressionInputStream.read(b, off, len);
                }

                public void resetState() throws IOException {
                    compressionInputStream.resetState();
                }

                public int read() throws IOException {
                    return compressionInputStream.read();
                }
            };
        }
        BGZFSplitGuesser splitGuesser = new BGZFSplitGuesser(seekableIn);
        long adjustedStart = splitGuesser.guessNextBGZFBlockStart(start, end);
        ((Seekable)seekableIn).seek(adjustedStart);
        return new BGZFSplitCompressionInputStream(seekableIn, adjustedStart, end);
    }
}

