/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;

class WorkaroundingStream
extends InputStream {
    private final InputStream stream;
    private final InputStream headerStream;
    private boolean headerRemaining;
    private long length;
    private int headerLength;
    private boolean lookingForEOL;
    private boolean foundEOL;
    private boolean strippingAts;
    private byte[] readBuf;

    public WorkaroundingStream(InputStream stream, SAMFileHeader header) {
        byte[] b;
        block3: {
            this.lookingForEOL = false;
            this.foundEOL = false;
            this.strippingAts = false;
            this.readBuf = new byte[1];
            this.stream = stream;
            String text = header.getTextHeader();
            if (text == null) {
                StringWriter writer = new StringWriter();
                new SAMTextHeaderCodec().encode(writer, header);
                text = writer.toString();
            }
            try {
                b = text.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                b = null;
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        this.headerRemaining = true;
        this.headerLength = b.length;
        this.headerStream = new ByteArrayInputStream(b);
        this.length = Long.MAX_VALUE;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public int getRemainingHeaderLength() {
        return this.headerLength;
    }

    @Override
    public int read() throws IOException {
        block5: while (true) {
            switch (this.read(this.readBuf)) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    return this.readBuf[0];
                }
                case -1: {
                    return -1;
                }
            }
        }
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int h;
        if (!this.headerRemaining) {
            return this.streamRead(buf, off, len);
        }
        if (this.strippingAts) {
            h = 0;
        } else {
            h = this.headerStream.read(buf, off, len);
            if (h == -1) {
                assert (this.headerLength == 0);
                h = 0;
            } else if (h < this.headerLength) {
                this.headerLength -= h;
                return h;
            }
            this.strippingAts = true;
            this.headerStream.close();
        }
        int newOff = off + h;
        int s = this.streamRead(buf, newOff, len - h);
        if (s <= 0) {
            return this.strippingAts ? s : h;
        }
        int i = newOff - 1;
        while (buf[++i] == 64 && --s > 0) {
        }
        if (i != newOff) {
            System.arraycopy(buf, i, buf, newOff, s);
        }
        this.headerRemaining = s == 0;
        return h + s;
    }

    private int streamRead(byte[] buf, int off, int len) throws IOException {
        int n;
        if ((long)len > this.length) {
            if (this.foundEOL) {
                return 0;
            }
            this.lookingForEOL = true;
        }
        if ((n = this.stream.read(buf, off, len)) > 0) {
            n = this.tryFindEOL(buf, off, n);
            this.length -= (long)n;
        }
        return n;
    }

    private int tryFindEOL(byte[] buf, int off, int len) {
        assert (!this.foundEOL);
        if (!this.lookingForEOL || (long)len < this.length) {
            return len;
        }
        for (int i = Math.max(0, (int)this.length - 1); i < len; ++i) {
            if (buf[off + i] != 10) continue;
            this.foundEOL = true;
            return i + 1;
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public int available() throws IOException {
        return this.headerRemaining ? this.headerStream.available() : this.stream.available();
    }
}

