/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.AsciiLineReaderIterator;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.seqdoop.hadoop_bam.LazyBCFGenotypesContext;
import org.seqdoop.hadoop_bam.LazyParsingGenotypesContext;
import org.seqdoop.hadoop_bam.LazyVCFGenotypesContext;
import org.seqdoop.hadoop_bam.StoppableOutputStream;
import org.seqdoop.hadoop_bam.VariantContextWritable;

public abstract class VCFRecordWriter<K>
extends RecordWriter<K, VariantContextWritable> {
    private VCFCodec codec = new VCFCodec();
    private VariantContextWriter writer;
    private LazyVCFGenotypesContext.HeaderDataCache vcfHeaderDataCache = new LazyVCFGenotypesContext.HeaderDataCache();
    private LazyBCFGenotypesContext.HeaderDataCache bcfHeaderDataCache = new LazyBCFGenotypesContext.HeaderDataCache();

    public VCFRecordWriter(Path output, Path input, boolean writeHeader, TaskAttemptContext ctx) throws IOException {
        AsciiLineReader r = new AsciiLineReader((InputStream)input.getFileSystem(ctx.getConfiguration()).open(input));
        FeatureCodecHeader h = this.codec.readHeader(new AsciiLineReaderIterator(r));
        if (h == null || !(h.getHeaderValue() instanceof VCFHeader)) {
            throw new IOException("No VCF header found in " + input);
        }
        r.close();
        this.init(output, (VCFHeader)h.getHeaderValue(), writeHeader, ctx);
    }

    public VCFRecordWriter(Path output, VCFHeader header, boolean writeHeader, TaskAttemptContext ctx) throws IOException {
        this.init((OutputStream)output.getFileSystem(ctx.getConfiguration()).create(output), header, writeHeader);
    }

    public VCFRecordWriter(OutputStream output, VCFHeader header, boolean writeHeader) throws IOException {
        this.init(output, header, writeHeader);
    }

    private void init(Path output, VCFHeader header, boolean writeHeader, TaskAttemptContext ctx) throws IOException {
        this.init((OutputStream)output.getFileSystem(ctx.getConfiguration()).create(output), header, writeHeader);
    }

    private void init(OutputStream output, VCFHeader header, boolean writeHeader) throws IOException {
        StoppableOutputStream stopOut = new StoppableOutputStream(!writeHeader, output);
        this.writer = new VariantContextWriterBuilder().clearOptions().setOutputStream(stopOut).build();
        this.writer.writeHeader(header);
        stopOut.stopped = false;
        this.setInputHeader(header);
    }

    public void close(TaskAttemptContext ctx) throws IOException {
        this.writer.close();
    }

    public void setInputHeader(VCFHeader header) {
        this.vcfHeaderDataCache.setHeader(header);
        this.bcfHeaderDataCache.setHeader(header);
    }

    protected void writeRecord(VariantContext vc) {
        GenotypesContext gc = vc.getGenotypes();
        if (gc instanceof LazyParsingGenotypesContext) {
            ((LazyParsingGenotypesContext)gc).getParser().setHeaderDataCache(gc instanceof LazyVCFGenotypesContext ? this.vcfHeaderDataCache : this.bcfHeaderDataCache);
        }
        this.writer.add(vc);
    }
}

