/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class SplittingBAMIndexer {
    public static final String OUTPUT_FILE_EXTENSION = ".splitting-bai";
    public static final int DEFAULT_GRANULARITY = 4096;
    private final OutputStream out;
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(8);
    private final int granularity;
    private final LongBuffer lb;
    private long count;
    private Method getFirstOffset;
    private static final int PRINT_EVERY = 524288000;

    public static void main(String[] args) {
        int granularity;
        if (args.length <= 1) {
            System.out.println("Usage: SplittingBAMIndexer GRANULARITY [BAM files...]\n\nWrites, for each GRANULARITY alignments in a BAM file, its virtual file offset\nas a big-endian 64-bit integer into [filename].splitting-bai. The file is\nterminated by the BAM file's length, in the same format.");
            return;
        }
        try {
            granularity = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            granularity = 0;
        }
        if (granularity <= 0) {
            System.err.printf("Granularity must be a positive integer, not '%s'!\n", args[0]);
            return;
        }
        for (String arg : Arrays.asList(args).subList(1, args.length)) {
            File f = new File(arg);
            System.out.printf("Indexing %s...", f);
            try {
                SplittingBAMIndexer.index(new FileInputStream(f), new BufferedOutputStream(new FileOutputStream(f + OUTPUT_FILE_EXTENSION)), f.length(), granularity);
                System.out.println(" done.");
            }
            catch (IOException e) {
                System.out.println(" FAILED!");
                e.printStackTrace();
            }
        }
    }

    public static void run(Configuration conf) throws IOException {
        String inputString = conf.get("input");
        if (inputString == null) {
            throw new IllegalArgumentException("String property \"input\" path not found in given Configuration");
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path input = new Path(inputString);
        SplittingBAMIndexer.index((InputStream)fs.open(input), (OutputStream)fs.create(input.suffix(OUTPUT_FILE_EXTENSION)), fs.getFileStatus(input).getLen(), conf.getInt("granularity", 4096));
    }

    @Deprecated
    public SplittingBAMIndexer(int g) {
        this.granularity = g;
        this.out = null;
        this.lb = null;
    }

    public SplittingBAMIndexer(OutputStream out) {
        this(out, 4096);
    }

    public SplittingBAMIndexer(OutputStream out, int granularity) {
        this.out = out;
        this.lb = this.byteBuffer.order(ByteOrder.BIG_ENDIAN).asLongBuffer();
        this.granularity = granularity;
    }

    public void processAlignment(SAMRecord rec) throws IOException {
        if (this.count == 0L || (this.count + 1L) % (long)this.granularity == 0L) {
            SAMFileSource fileSource = rec.getFileSource();
            SAMFileSpan filePointer = fileSource.getFilePointer();
            this.writeVirtualOffset(this.getPos(filePointer));
        }
        ++this.count;
    }

    void processAlignment(long virtualOffset) throws IOException {
        if (this.count == 0L || (this.count + 1L) % (long)this.granularity == 0L) {
            this.writeVirtualOffset(virtualOffset);
        }
        ++this.count;
    }

    private long getPos(SAMFileSpan filePointer) {
        if (this.getFirstOffset == null) {
            try {
                this.getFirstOffset = filePointer.getClass().getDeclaredMethod("getFirstOffset", new Class[0]);
                this.getFirstOffset.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            return (Long)this.getFirstOffset.invoke((Object)filePointer, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public void writeVirtualOffset(long virtualOffset) throws IOException {
        this.lb.put(0, virtualOffset);
        this.out.write(this.byteBuffer.array());
    }

    public void finish(long inputSize) throws IOException {
        this.writeVirtualOffset(inputSize << 16);
        this.out.close();
    }

    public static void index(InputStream rawIn, OutputStream out, long inputSize, int granularity) throws IOException {
        PtrSkipPair pair;
        BlockCompressedInputStream in = new BlockCompressedInputStream(rawIn);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        LongBuffer lb = byteBuffer.order(ByteOrder.BIG_ENDIAN).asLongBuffer();
        SplittingBAMIndexer.skipToAlignmentList(byteBuffer, in);
        lb.put(0, in.getFilePointer());
        out.write(byteBuffer.array());
        long prevPrint = in.getFilePointer() >> 16;
        int i = 0;
        while ((pair = SplittingBAMIndexer.readAlignment(byteBuffer, in)) != null) {
            if (++i == granularity) {
                i = 0;
                lb.put(0, pair.ptr);
                out.write(byteBuffer.array());
                long filePos = pair.ptr >> 16;
                if (filePos - prevPrint >= 524288000L) {
                    System.out.print("-");
                    prevPrint = filePos;
                }
            }
            SplittingBAMIndexer.fullySkip(in, pair.skip);
        }
        lb.put(0, inputSize << 16);
        out.write(byteBuffer.array());
        out.close();
        in.close();
    }

    private static void skipToAlignmentList(ByteBuffer byteBuffer, InputStream in) throws IOException {
        int magic;
        if (!SplittingBAMIndexer.readExactlyBytes(byteBuffer, in, 4)) {
            SplittingBAMIndexer.ioError("Invalid BAM header: too short, no magic", new Object[0]);
        }
        if ((magic = byteBuffer.order(ByteOrder.BIG_ENDIAN).getInt(0)) != 1111575809) {
            SplittingBAMIndexer.ioError("Invalid BAM header: bad magic %#x != 0x42414d01", magic);
        }
        if (!SplittingBAMIndexer.readExactlyBytes(byteBuffer, in, 4)) {
            SplittingBAMIndexer.ioError("Invalid BAM header: too short, no SAM header length", new Object[0]);
        }
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int samLen = byteBuffer.getInt(0);
        if (samLen < 0) {
            SplittingBAMIndexer.ioError("Invalid BAM header: negative SAM header length %d", samLen);
        }
        SplittingBAMIndexer.fullySkip(in, samLen);
        if (!SplittingBAMIndexer.readExactlyBytes(byteBuffer, in, 4)) {
            SplittingBAMIndexer.ioError("Invalid BAM header: too short, no reference sequence count", new Object[0]);
        }
        int referenceSeqs = byteBuffer.getInt(0);
        for (int s = 0; s < referenceSeqs; ++s) {
            if (!SplittingBAMIndexer.readExactlyBytes(byteBuffer, in, 4)) {
                SplittingBAMIndexer.ioError("Invalid reference list: EOF before reference %d", s + 1);
            }
            SplittingBAMIndexer.fullySkip(in, byteBuffer.getInt(0) + 4);
        }
    }

    private static PtrSkipPair readAlignment(ByteBuffer byteBuffer, BlockCompressedInputStream in) throws IOException {
        long ptr = in.getFilePointer();
        int read = SplittingBAMIndexer.readBytes(byteBuffer, in, 4);
        if (read != 4) {
            if (read == 0) {
                return null;
            }
            SplittingBAMIndexer.ioError("Invalid alignment at virtual offset %#x: less than 4 bytes long", in.getFilePointer());
        }
        return new PtrSkipPair(ptr, byteBuffer.getInt(0));
    }

    private static void fullySkip(InputStream in, int skip) throws IOException {
        int s = skip;
        while (s > 0) {
            long skipped = in.skip(s);
            if (skipped == 0L) {
                throw new IOException("Skip failed");
            }
            s = (int)((long)s - skipped);
        }
    }

    private static int readBytes(ByteBuffer byteBuffer, InputStream in, int n) throws IOException {
        int read;
        int readNow;
        assert (n <= byteBuffer.capacity());
        for (read = 0; read < n && (readNow = in.read(byteBuffer.array(), read, n - read)) > 0; read += readNow) {
        }
        return read;
    }

    private static boolean readExactlyBytes(ByteBuffer byteBuffer, InputStream in, int n) throws IOException {
        return SplittingBAMIndexer.readBytes(byteBuffer, in, n) == n;
    }

    private static void ioError(String s, Object ... va) throws IOException {
        throw new IOException(String.format(s, va));
    }

    private static final class PtrSkipPair {
        public long ptr;
        public int skip;

        public PtrSkipPair(long p, int s) {
            this.ptr = p;
            this.skip = s;
        }
    }
}

