/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.seqdoop.hadoop_bam.LazyBAMRecordFactory;
import org.seqdoop.hadoop_bam.util.DataInputWrapper;
import org.seqdoop.hadoop_bam.util.DataOutputWrapper;

public class SAMRecordWritable
implements Writable {
    private static final BAMRecordCodec lazyCodec = new BAMRecordCodec(null, new LazyBAMRecordFactory());
    private SAMRecord record;

    public SAMRecord get() {
        return this.record;
    }

    public void set(SAMRecord r) {
        this.record = r;
    }

    public void write(DataOutput out) throws IOException {
        BAMRecordCodec codec = new BAMRecordCodec(this.record.getHeader());
        codec.setOutputStream(new DataOutputWrapper(out));
        codec.encode(this.record);
    }

    public void readFields(DataInput in) throws IOException {
        lazyCodec.setInputStream(new DataInputWrapper(in));
        this.record = lazyCodec.decode();
    }

    public String toString() {
        return this.record.getSAMString().trim();
    }
}

