/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.LazyGenotypesContext;
import htsjdk.variant.vcf.AbstractVCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderVersion;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.seqdoop.hadoop_bam.HeaderSettableVCFCodec;
import org.seqdoop.hadoop_bam.LazyParsingGenotypesContext;

public class LazyVCFGenotypesContext
extends LazyParsingGenotypesContext {
    public LazyVCFGenotypesContext(List<Allele> alleles, String chrom, int start, byte[] utf8Unparsed, int count) {
        super(new Parser(alleles, chrom, start), utf8Unparsed, count);
    }

    public static class Parser
    extends LazyParsingGenotypesContext.Parser {
        private HeaderSettableVCFCodec codec = null;
        private final List<Allele> alleles;
        private final String chrom;
        private final int start;

        public Parser(List<Allele> alleles, String chrom, int start) {
            this.alleles = alleles;
            this.chrom = chrom;
            this.start = start;
        }

        @Override
        public void setHeaderDataCache(LazyParsingGenotypesContext.HeaderDataCache data) {
            this.codec = (HeaderSettableVCFCodec)((HeaderDataCache)data).getCodec();
        }

        @Override
        public LazyGenotypesContext.LazyData parse(Object data) {
            String str;
            if (this.codec == null || !this.codec.hasHeader()) {
                throw new IllegalStateException("Cannot decode genotypes without a codec with a VCFHeader");
            }
            try {
                str = new String((byte[])data, "UTF-8");
            }
            catch (UnsupportedEncodingException absurd) {
                throw new RuntimeException("Can never happen on a compliant Java implementation because UTF-8 is guaranteed to be supported");
            }
            return this.codec.createGenotypeMap(str, this.alleles, this.chrom, this.start);
        }
    }

    public static class HeaderDataCache
    implements LazyParsingGenotypesContext.HeaderDataCache {
        private HeaderSettableVCFCodec codec = new HeaderSettableVCFCodec();

        @Override
        public void setHeader(VCFHeader header) {
            VCFHeaderVersion version = null;
            for (VCFHeaderLine line : header.getMetaDataInInputOrder()) {
                if (!VCFHeaderVersion.isFormatString(line.getKey())) continue;
                version = VCFHeaderVersion.toHeaderVersion(line.getValue());
                break;
            }
            this.codec.setHeaderAndVersion(header, version);
        }

        public AbstractVCFCodec getCodec() {
            return this.codec;
        }
    }
}

