/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.tribble.TribbleException;
import htsjdk.variant.bcf2.BCF2Decoder;
import htsjdk.variant.bcf2.BCF2GenotypeFieldDecoders;
import htsjdk.variant.bcf2.BCF2Utils;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.LazyGenotypesContext;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.seqdoop.hadoop_bam.LazyParsingGenotypesContext;

public class LazyBCFGenotypesContext
extends LazyParsingGenotypesContext {
    public LazyBCFGenotypesContext(List<Allele> alleles, int fields, byte[] unparsed, int count) {
        super(new Parser(alleles, fields), unparsed, count);
    }

    public static class Parser
    extends LazyParsingGenotypesContext.Parser {
        private final List<Allele> alleles;
        private final int fields;
        private HeaderDataCache hd = null;

        public Parser(List<Allele> alleles, int fields) {
            this.alleles = alleles;
            this.fields = fields;
        }

        @Override
        public void setHeaderDataCache(LazyParsingGenotypesContext.HeaderDataCache data) {
            this.hd = (HeaderDataCache)data;
        }

        @Override
        public LazyGenotypesContext.LazyData parse(Object data) {
            if (this.hd == null) {
                throw new IllegalStateException("Cannot decode genotypes without HeaderDataCache");
            }
            GenotypeBuilder[] builders = this.hd.getBuilders();
            try {
                HeaderDataCache.decoder.setRecordBytes((byte[])data);
                for (GenotypeBuilder gb : builders) {
                    gb.reset(true);
                }
                for (int i = 0; i < this.fields; ++i) {
                    String field = this.hd.getFieldDict().get((Integer)HeaderDataCache.decoder.decodeTypedValue());
                    byte type = HeaderDataCache.decoder.readTypeDescriptor();
                    int numElems = HeaderDataCache.decoder.decodeNumberOfElements(type);
                    this.hd.getGenoFieldDecoders().getDecoder(field).decode(this.alleles, field, HeaderDataCache.decoder, type, numElems, builders);
                }
                ArrayList<Genotype> genotypes = new ArrayList<Genotype>(builders.length);
                for (GenotypeBuilder gb : builders) {
                    genotypes.add(gb.make());
                }
                return new LazyGenotypesContext.LazyData(genotypes, this.hd.getSampleNamesInOrder(), this.hd.getSampleNameToOffset());
            }
            catch (IOException e) {
                throw new TribbleException("Unexpected IOException parsing genotypes data block", e);
            }
        }
    }

    public static class HeaderDataCache
    implements LazyParsingGenotypesContext.HeaderDataCache {
        public static final BCF2Decoder decoder = new BCF2Decoder();
        private BCF2GenotypeFieldDecoders genoFieldDecoders;
        private List<String> fieldDict;
        private GenotypeBuilder[] builders;
        private ArrayList<String> sampleNamesInOrder;
        private HashMap<String, Integer> sampleNameToOffset;

        @Override
        public void setHeader(VCFHeader header) {
            this.genoFieldDecoders = new BCF2GenotypeFieldDecoders(header);
            this.fieldDict = BCF2Utils.makeDictionary(header);
            this.builders = new GenotypeBuilder[header.getNGenotypeSamples()];
            List<String> genotypeSamples = header.getGenotypeSamples();
            for (int i = 0; i < this.builders.length; ++i) {
                this.builders[i] = new GenotypeBuilder(genotypeSamples.get(i));
            }
            this.sampleNamesInOrder = header.getSampleNamesInOrder();
            this.sampleNameToOffset = header.getSampleNameToOffset();
        }

        public BCF2GenotypeFieldDecoders getGenoFieldDecoders() {
            return this.genoFieldDecoders;
        }

        public List<String> getFieldDict() {
            return this.fieldDict;
        }

        public GenotypeBuilder[] getBuilders() {
            return this.builders;
        }

        public ArrayList<String> getSampleNamesInOrder() {
            return this.sampleNamesInOrder;
        }

        public HashMap<String, Integer> getSampleNameToOffset() {
            return this.sampleNameToOffset;
        }
    }
}

