/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.CRAMContainerStreamWriter;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.ref.ReferenceSource;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Paths;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;

public abstract class CRAMRecordWriter<K>
extends RecordWriter<K, SAMRecordWritable> {
    private static final String HADOOP_BAM_PART_ID = "Hadoop-BAM-Part";
    private OutputStream origOutput;
    private CRAMContainerStreamWriter cramContainerStream = null;
    private ReferenceSource refSource = null;
    private boolean writeHeader = true;

    public CRAMRecordWriter(Path output, Path input, boolean writeHeader, TaskAttemptContext ctx) throws IOException {
        this.init(output, SAMHeaderReader.readSAMHeaderFrom(input, ctx.getConfiguration()), writeHeader, ctx);
    }

    public CRAMRecordWriter(Path output, SAMFileHeader header, boolean writeHeader, TaskAttemptContext ctx) throws IOException {
        this.init((OutputStream)output.getFileSystem(ctx.getConfiguration()).create(output), header, writeHeader, ctx);
    }

    private void init(Path output, SAMFileHeader header, boolean writeHeader, TaskAttemptContext ctx) throws IOException {
        this.init((OutputStream)output.getFileSystem(ctx.getConfiguration()).create(output), header, writeHeader, ctx);
    }

    private void init(OutputStream output, SAMFileHeader header, boolean writeHeader, TaskAttemptContext ctx) throws IOException {
        this.origOutput = output;
        this.writeHeader = writeHeader;
        URI referenceURI = URI.create(ctx.getConfiguration().get("hadoopbam.cram.reference-source-path"));
        this.refSource = new ReferenceSource(Paths.get(referenceURI));
        if (header != null) {
            this.cramContainerStream = new CRAMContainerStreamWriter(this.origOutput, null, this.refSource, header, HADOOP_BAM_PART_ID);
            if (writeHeader) {
                this.writeHeader(header);
            }
        }
    }

    public void close(TaskAttemptContext ctx) throws IOException {
        this.cramContainerStream.finish(false);
        this.origOutput.close();
    }

    protected void writeAlignment(SAMRecord rec) {
        if (null == this.cramContainerStream) {
            SAMFileHeader header = rec.getHeader();
            if (header == null) {
                throw new RuntimeException("Cannot write record to CRAM: null header in SAM record");
            }
            if (this.writeHeader) {
                this.writeHeader(header);
            }
            this.cramContainerStream = new CRAMContainerStreamWriter(this.origOutput, null, this.refSource, header, HADOOP_BAM_PART_ID);
        }
        this.cramContainerStream.writeAlignment(rec);
    }

    private void writeHeader(SAMFileHeader header) {
        this.cramContainerStream.writeHeader(header);
    }
}

