/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.CRAMIterator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.BAMRecordReader;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;
import org.seqdoop.hadoop_bam.util.WrapSeekable;

public class CRAMRecordReader
extends RecordReader<LongWritable, SAMRecordWritable> {
    private final LongWritable key = new LongWritable();
    private final SAMRecordWritable record = new SAMRecordWritable();
    private boolean isInitialized = false;
    private SeekableStream seekableStream;
    private long start;
    private long length;
    private CRAMIterator cramIterator;

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        if (this.isInitialized) {
            this.close();
        }
        this.isInitialized = true;
        Configuration conf = context.getConfiguration();
        FileSplit fileSplit = (FileSplit)split;
        Path file = fileSplit.getPath();
        String refSourcePath = conf.get("hadoopbam.cram.reference-source-path");
        ReferenceSource refSource = new ReferenceSource(refSourcePath == null ? null : Paths.get(URI.create(refSourcePath)));
        this.seekableStream = WrapSeekable.openPath(conf, file);
        this.start = fileSplit.getStart();
        this.length = fileSplit.getLength();
        long end = this.start + this.length;
        long[] boundaries = new long[]{this.start << 16, end - 1L << 16};
        this.cramIterator = new CRAMIterator(this.seekableStream, (CRAMReferenceSource)refSource, boundaries);
        ValidationStringency stringency = SAMHeaderReader.getValidationStringency(conf);
        if (stringency != null) {
            this.cramIterator.setValidationStringency(stringency);
        }
    }

    public boolean nextKeyValue() {
        if (!this.cramIterator.hasNext()) {
            return false;
        }
        SAMRecord r = this.cramIterator.next();
        this.key.set(BAMRecordReader.getKey(r));
        this.record.set(r);
        return true;
    }

    public LongWritable getCurrentKey() {
        return this.key;
    }

    public SAMRecordWritable getCurrentValue() {
        return this.record;
    }

    public float getProgress() throws IOException {
        return (float)(this.seekableStream.position() - this.start) / (float)this.length;
    }

    public void close() {
        this.cramIterator.close();
    }
}

