/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.variant.bcf2.BCF2Codec;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.BGZFLimitingStream;
import org.seqdoop.hadoop_bam.FileVirtualSplit;
import org.seqdoop.hadoop_bam.VariantContextWritable;
import org.seqdoop.hadoop_bam.util.MurmurHash3;
import org.seqdoop.hadoop_bam.util.WrapSeekable;

public class BCFRecordReader
extends RecordReader<LongWritable, VariantContextWritable> {
    private final LongWritable key = new LongWritable();
    private final VariantContextWritable vc = new VariantContextWritable();
    private BCF2Codec codec = new BCF2Codec();
    private PositionalBufferedStream in;
    private final Map<String, Integer> contigDict = new HashMap<String, Integer>();
    private boolean isBGZF;
    private BlockCompressedInputStream bci;
    private long fileStart;
    private long length;

    public void initialize(InputSplit spl, TaskAttemptContext ctx) throws IOException {
        this.isBGZF = spl instanceof FileVirtualSplit;
        if (this.isBGZF) {
            FileVirtualSplit split = (FileVirtualSplit)spl;
            Path file = split.getPath();
            FileSystem fs = file.getFileSystem(ctx.getConfiguration());
            FSDataInputStream inFile = fs.open(file);
            this.bci = new BlockCompressedInputStream((InputStream)inFile);
            this.in = new PositionalBufferedStream(this.bci);
            this.initContigDict();
            inFile.seek(0L);
            this.bci = new BlockCompressedInputStream(new WrapSeekable<FSDataInputStream>(inFile, fs.getFileStatus(file).getLen(), file));
            long virtualStart = split.getStartVirtualOffset();
            long virtualEnd = split.getEndVirtualOffset();
            this.fileStart = virtualStart >>> 16;
            this.length = (virtualEnd >>> 16) - this.fileStart;
            this.bci.seek(virtualStart);
            this.in = new PositionalBufferedStream(new BGZFLimitingStream(this.bci, virtualEnd));
        } else {
            FileSplit split = (FileSplit)spl;
            this.fileStart = split.getStart();
            this.length = split.getLength();
            Path file = split.getPath();
            this.in = new PositionalBufferedStream((InputStream)file.getFileSystem(ctx.getConfiguration()).open(file));
            this.initContigDict();
            IOUtils.skipFully((InputStream)this.in, (long)(this.fileStart - this.in.getPosition()));
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    private void initContigDict() {
        VCFHeader header = (VCFHeader)this.codec.readHeader(this.in).getHeaderValue();
        this.contigDict.clear();
        int i = 0;
        for (VCFContigHeaderLine contig : header.getContigLines()) {
            this.contigDict.put(contig.getID(), i++);
        }
    }

    public float getProgress() {
        if (this.length == 0L) {
            return 1.0f;
        }
        if (!this.isBGZF) {
            return (float)(this.in.getPosition() - this.fileStart) / (float)this.length;
        }
        try {
            if (this.in.peek() == -1) {
                return 1.0f;
            }
        }
        catch (IOException e) {
            return 1.0f;
        }
        return (float)((this.bci.getFilePointer() >>> 16) - this.fileStart) / (float)(this.length + 1L);
    }

    public LongWritable getCurrentKey() {
        return this.key;
    }

    public VariantContextWritable getCurrentValue() {
        return this.vc;
    }

    public boolean nextKeyValue() throws IOException {
        if (this.in.peek() == -1) {
            return false;
        }
        if (!this.isBGZF && this.in.getPosition() >= this.fileStart + this.length) {
            return false;
        }
        VariantContext v = this.codec.decode(this.in);
        Integer chromIdx = this.contigDict.get(v.getContig());
        if (chromIdx == null) {
            chromIdx = (int)MurmurHash3.murmurhash3(v.getContig(), 0);
        }
        this.key.set((long)chromIdx.intValue() << 32 | (long)(v.getStart() - 1));
        this.vc.set(v);
        return true;
    }
}

