/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.seqdoop.hadoop_bam.BAMInputFormat;
import org.seqdoop.hadoop_bam.FileVirtualSplit;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.util.MurmurHash3;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;
import org.seqdoop.hadoop_bam.util.WrapSeekable;

public class BAMRecordReader
extends RecordReader<LongWritable, SAMRecordWritable> {
    private final LongWritable key = new LongWritable();
    private final SAMRecordWritable record = new SAMRecordWritable();
    private ValidationStringency stringency;
    private BlockCompressedInputStream bci;
    private BAMRecordCodec codec;
    private long fileStart;
    private long virtualStart;
    private long virtualEnd;
    private boolean isInitialized = false;
    private boolean keepReadPairsTogether;
    private boolean readPair;
    private boolean lastOfPair;
    private List<Interval> intervals;
    private OverlapDetector<Interval> overlapDetector;

    public static long getKey(SAMRecord rec) {
        int refIdx = rec.getReferenceIndex();
        int start = rec.getAlignmentStart();
        if (!rec.getReadUnmappedFlag() && refIdx >= 0 && start >= 0) {
            return BAMRecordReader.getKey(refIdx, start);
        }
        int hash = 0;
        byte[] var = rec.getVariableBinaryRepresentation();
        if (var != null) {
            hash = (int)MurmurHash3.murmurhash3(var, hash);
        } else {
            hash = (int)MurmurHash3.murmurhash3(rec.getReadName(), hash);
            hash = (int)MurmurHash3.murmurhash3(rec.getReadBases(), hash);
            hash = (int)MurmurHash3.murmurhash3(rec.getBaseQualities(), hash);
            hash = (int)MurmurHash3.murmurhash3(rec.getCigarString(), hash);
        }
        return BAMRecordReader.getKey0(Integer.MAX_VALUE, hash);
    }

    public static long getKey(int refIdx, int alignmentStart) {
        return BAMRecordReader.getKey0(refIdx, alignmentStart - 1);
    }

    public static long getKey0(int refIdx, int alignmentStart0) {
        return (long)refIdx << 32 | (long)alignmentStart0;
    }

    public void initialize(InputSplit spl, TaskAttemptContext ctx) throws IOException {
        if (this.isInitialized) {
            this.close();
        }
        this.isInitialized = true;
        Configuration conf = ctx.getConfiguration();
        FileVirtualSplit split = (FileVirtualSplit)spl;
        Path file = split.getPath();
        FileSystem fs = file.getFileSystem(conf);
        this.stringency = SAMHeaderReader.getValidationStringency(conf);
        FSDataInputStream in = fs.open(file);
        SAMFileHeader header = SAMHeaderReader.readSAMHeaderFrom((InputStream)in, conf);
        this.codec = new BAMRecordCodec(header);
        in.seek(0L);
        this.bci = new BlockCompressedInputStream(new WrapSeekable<FSDataInputStream>(in, fs.getFileStatus(file).getLen(), file));
        this.virtualStart = split.getStartVirtualOffset();
        this.fileStart = this.virtualStart >>> 16;
        this.virtualEnd = split.getEndVirtualOffset();
        this.bci.seek(this.virtualStart);
        this.codec.setInputStream(this.bci);
        this.keepReadPairsTogether = SAMFileHeader.SortOrder.queryname.equals((Object)header.getSortOrder()) && conf.getBoolean("hadoopbam.bam.keep-paired-reads-together", false);
        this.readPair = false;
        this.lastOfPair = false;
        this.intervals = BAMInputFormat.getIntervals(conf);
        if (this.intervals != null) {
            this.overlapDetector = new OverlapDetector(0, 0);
            this.overlapDetector.addAll(this.intervals, this.intervals);
        }
    }

    public void close() throws IOException {
        this.bci.close();
    }

    public float getProgress() {
        long virtPos = this.bci.getFilePointer();
        long filePos = virtPos >>> 16;
        if (virtPos >= this.virtualEnd) {
            return 1.0f;
        }
        long fileEnd = this.virtualEnd >>> 16;
        return (float)(filePos - this.fileStart) / (float)(fileEnd - this.fileStart + 1L);
    }

    public LongWritable getCurrentKey() {
        return this.key;
    }

    public SAMRecordWritable getCurrentValue() {
        return this.record;
    }

    public boolean nextKeyValue() {
        long virtPos;
        while ((virtPos = this.bci.getFilePointer()) < this.virtualEnd || this.keepReadPairsTogether && this.readPair && !this.lastOfPair) {
            SAMRecord r = this.codec.decode();
            if (r == null) {
                return false;
            }
            if (this.stringency != null) {
                r.setValidationStringency(this.stringency);
            }
            this.readPair = r.getReadPairedFlag();
            if (this.readPair) {
                boolean first = r.getFirstOfPairFlag();
                boolean second = r.getSecondOfPairFlag();
                boolean firstOfPair = first && !second;
                boolean bl = this.lastOfPair = !first && second;
                if (virtPos == this.virtualStart && this.keepReadPairsTogether && !firstOfPair) continue;
            }
            if (!this.overlaps(r)) continue;
            this.key.set(BAMRecordReader.getKey(r));
            this.record.set(r);
            return true;
        }
        return false;
    }

    private boolean overlaps(SAMRecord r) {
        Interval interval;
        Set<Interval> set;
        if (this.intervals == null || r.getReadUnmappedFlag() && r.getAlignmentStart() == 0) {
            return true;
        }
        if (r.getReadUnmappedFlag()) {
            for (Locatable locatable : this.intervals) {
                if (locatable.getStart() > r.getStart() || locatable.getEnd() < r.getStart()) continue;
                return true;
            }
        }
        return !(set = this.overlapDetector.getOverlaps(interval = new Interval(r.getContig(), r.getStart(), r.getEnd()))).isEmpty();
    }
}

