/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.DiskBasedBAMFileIndex;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamFiles;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Locatable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.BAMRecordReader;
import org.seqdoop.hadoop_bam.BAMSplitGuesser;
import org.seqdoop.hadoop_bam.FileVirtualSplit;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.SplittingBAMIndex;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;
import org.seqdoop.hadoop_bam.util.WrapSeekable;

public class BAMInputFormat
extends FileInputFormat<LongWritable, SAMRecordWritable> {
    public static final boolean DEBUG_BAM_SPLITTER = false;
    public static final String KEEP_PAIRED_READS_TOGETHER_PROPERTY = "hadoopbam.bam.keep-paired-reads-together";
    public static final String INTERVALS_PROPERTY = "hadoopbam.bam.intervals";

    public static <T extends Locatable> void setIntervals(Configuration conf, List<T> intervals) {
        StringBuilder sb = new StringBuilder();
        Iterator<T> it = intervals.iterator();
        while (it.hasNext()) {
            Locatable l = (Locatable)it.next();
            sb.append(String.format("%s:%d-%d", l.getContig(), l.getStart(), l.getEnd()));
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        conf.set(INTERVALS_PROPERTY, sb.toString());
    }

    static List<Interval> getIntervals(Configuration conf) {
        String intervalsProperty = conf.get(INTERVALS_PROPERTY);
        if (intervalsProperty == null) {
            return null;
        }
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        for (String s : intervalsProperty.split(",")) {
            String[] parts = s.split(":|-");
            Interval interval = new Interval(parts[0], Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
            intervals.add(interval);
        }
        return intervals;
    }

    static Path getIdxPath(Path path) {
        return path.suffix(".splitting-bai");
    }

    public RecordReader<LongWritable, SAMRecordWritable> createRecordReader(InputSplit split, TaskAttemptContext ctx) throws InterruptedException, IOException {
        BAMRecordReader rr = new BAMRecordReader();
        rr.initialize(split, ctx);
        return rr;
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        return this.getSplits(super.getSplits(job), job.getConfiguration());
    }

    public List<InputSplit> getSplits(List<InputSplit> splits, Configuration cfg) throws IOException {
        Collections.sort(splits, new Comparator<InputSplit>(){

            @Override
            public int compare(InputSplit a, InputSplit b) {
                FileSplit fa = (FileSplit)a;
                FileSplit fb = (FileSplit)b;
                return fa.getPath().compareTo((Object)fb.getPath());
            }
        });
        ArrayList<InputSplit> newSplits = new ArrayList<InputSplit>(splits.size());
        int i = 0;
        while (i < splits.size()) {
            try {
                i = this.addIndexedSplits(splits, i, newSplits, cfg);
            }
            catch (IOException e) {
                i = this.addProbabilisticSplits(splits, i, newSplits, cfg);
            }
        }
        return this.filterByInterval(newSplits, cfg);
    }

    private int addIndexedSplits(List<InputSplit> splits, int i, List<InputSplit> newSplits, Configuration cfg) throws IOException {
        int j;
        Path file = ((FileSplit)splits.get(i)).getPath();
        ArrayList<FileVirtualSplit> potentialSplits = new ArrayList<FileVirtualSplit>();
        SplittingBAMIndex idx = new SplittingBAMIndex((InputStream)file.getFileSystem(cfg).open(BAMInputFormat.getIdxPath(file)));
        int splitsEnd = splits.size();
        for (j = i; j < splitsEnd; ++j) {
            if (file.equals((Object)((FileSplit)splits.get(j)).getPath())) continue;
            splitsEnd = j;
        }
        for (j = i; j < splitsEnd; ++j) {
            FileSplit fileSplit = (FileSplit)splits.get(j);
            long start = fileSplit.getStart();
            long end = start + fileSplit.getLength();
            Long blockStart = idx.nextAlignment(start);
            Long blockEnd = j == splitsEnd - 1 ? Long.valueOf(idx.prevAlignment(end) | 0xFFFFL) : idx.nextAlignment(end);
            if (blockStart == null || blockEnd == null) {
                System.err.println("Warning: index for " + file.toString() + " was not good. Generating probabilistic splits.");
                return this.addProbabilisticSplits(splits, i, newSplits, cfg);
            }
            potentialSplits.add(new FileVirtualSplit(file, blockStart, blockEnd, fileSplit.getLocations()));
        }
        for (InputSplit inputSplit : potentialSplits) {
            newSplits.add(inputSplit);
        }
        return splitsEnd;
    }

    private int addProbabilisticSplits(List<InputSplit> splits, int i, List<InputSplit> newSplits, Configuration cfg) throws IOException {
        FileSplit fspl;
        Path path = ((FileSplit)splits.get(i)).getPath();
        WrapSeekable<FSDataInputStream> sin = WrapSeekable.openPath(path.getFileSystem(cfg), path);
        BAMSplitGuesser guesser = new BAMSplitGuesser(sin, cfg);
        FileVirtualSplit previousSplit = null;
        while (i < splits.size() && (fspl = (FileSplit)splits.get(i)).getPath().equals((Object)path)) {
            long beg = fspl.getStart();
            long end = beg + fspl.getLength();
            long alignedBeg = guesser.guessNextBAMRecordStart(beg, end);
            long alignedEnd = end << 16 | 0xFFFFL;
            if (alignedBeg == end) {
                if (previousSplit == null) {
                    throw new IOException("'" + path + "': " + "no reads in first split: bad BAM file or tiny split size?");
                }
                previousSplit.setEndVirtualOffset(alignedEnd);
            } else {
                previousSplit = new FileVirtualSplit(path, alignedBeg, alignedEnd, fspl.getLocations());
                newSplits.add(previousSplit);
            }
            ++i;
        }
        ((SeekableStream)sin).close();
        return i;
    }

    private List<InputSplit> filterByInterval(List<InputSplit> splits, Configuration conf) throws IOException {
        List<Interval> intervals = BAMInputFormat.getIntervals(conf);
        if (intervals == null) {
            return splits;
        }
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        LinkedHashSet<Path> bamFiles = new LinkedHashSet<Path>();
        for (InputSplit split : splits) {
            bamFiles.add(((FileVirtualSplit)split).getPath());
        }
        for (Path bamFile : bamFiles) {
            FileSystem fs = bamFile.getFileSystem(conf);
            java.nio.file.Path index = SamFiles.findIndex(Paths.get(fs.makeQualified(bamFile).toUri()));
            if (index == null) {
                System.err.println("WARNING: no BAM index file found, splits will not be filtered, which may be very inefficient: " + bamFile);
                return splits;
            }
            Path indexFile = new Path(index.toUri());
            FSDataInputStream in = fs.open(bamFile);
            SAMFileHeader header = SAMHeaderReader.readSAMHeaderFrom((InputStream)in, conf);
            SAMSequenceDictionary dict = header.getSequenceDictionary();
            WrapSeekable<FSDataInputStream> seekableIdxFile = WrapSeekable.openPath(conf, indexFile);
            DiskBasedBAMFileIndex idx = new DiskBasedBAMFileIndex(seekableIdxFile, dict);
            for (Locatable locatable : intervals) {
                int referenceIndex = dict.getSequenceIndex(locatable.getContig());
                int intervalStart = locatable.getStart();
                int intervalEnd = locatable.getEnd();
                BAMFileSpan sfs = idx.getSpanOverlapping(referenceIndex, intervalStart, intervalEnd);
                chunks.addAll(sfs.getChunks());
            }
        }
        ArrayList<InputSplit> filteredSplits = new ArrayList<InputSplit>();
        for (InputSplit split : splits) {
            FileVirtualSplit virtualSplit = (FileVirtualSplit)split;
            long splitStart = virtualSplit.getStartVirtualOffset();
            long splitEnd = virtualSplit.getEndVirtualOffset();
            long newStart = Long.MAX_VALUE;
            long newEnd = Long.MIN_VALUE;
            boolean overlaps = false;
            for (Chunk chunk : chunks) {
                long chunkEnd;
                long chunkStart = chunk.getChunkStart();
                if (!BAMInputFormat.overlaps(splitStart, splitEnd, chunkStart, chunkEnd = chunk.getChunkEnd())) continue;
                long overlapStart = Math.max(splitStart, chunkStart);
                long overlapEnd = Math.min(splitEnd, chunkEnd);
                newStart = Math.min(newStart, overlapStart);
                newEnd = Math.max(newEnd, overlapEnd);
                overlaps = true;
            }
            if (!overlaps) continue;
            filteredSplits.add(new FileVirtualSplit(virtualSplit.getPath(), newStart, newEnd, virtualSplit.getLocations()));
        }
        return filteredSplits;
    }

    static boolean overlaps(long start, long end, long start2, long end2) {
        return start2 >= start && start2 <= end || end2 >= start && end2 <= end || start >= start2 && end <= end2;
    }

    public boolean isSplitable(JobContext job, Path path) {
        return true;
    }
}

