/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.BAMInputFormat;
import org.seqdoop.hadoop_bam.CRAMInputFormat;
import org.seqdoop.hadoop_bam.FileVirtualSplit;
import org.seqdoop.hadoop_bam.SAMFormat;
import org.seqdoop.hadoop_bam.SAMInputFormat;
import org.seqdoop.hadoop_bam.SAMRecordWritable;

public class AnySAMInputFormat
extends FileInputFormat<LongWritable, SAMRecordWritable> {
    public static final String TRUST_EXTS_PROPERTY = "hadoopbam.anysam.trust-exts";
    private final BAMInputFormat bamIF = new BAMInputFormat();
    private final CRAMInputFormat cramIF = new CRAMInputFormat();
    private final SAMInputFormat samIF = new SAMInputFormat();
    private final Map<Path, SAMFormat> formatMap;
    private final boolean givenMap;
    private Configuration conf;

    public AnySAMInputFormat() {
        this(null, new HashMap<Path, SAMFormat>(), false);
    }

    public AnySAMInputFormat(Configuration conf) {
        this(conf, new HashMap<Path, SAMFormat>(), false);
    }

    private static boolean trustExtensions(Configuration conf) {
        return conf.getBoolean(TRUST_EXTS_PROPERTY, true);
    }

    public AnySAMInputFormat(Map<Path, SAMFormat> formatMap) {
        this(null, formatMap, true);
    }

    private AnySAMInputFormat(Configuration conf, Map<Path, SAMFormat> formatMap, boolean givenMap) {
        this.formatMap = formatMap;
        this.givenMap = givenMap;
        this.conf = conf;
    }

    public SAMFormat getFormat(Path path) throws PathNotFoundException {
        SAMFormat f;
        SAMFormat fmt = this.formatMap.get(path);
        if (fmt != null || this.formatMap.containsKey(path)) {
            return fmt;
        }
        if (this.givenMap) {
            throw new IllegalArgumentException("SAM format for '" + path + "' not in given map");
        }
        if (this.conf == null) {
            throw new IllegalStateException("Don't have a Configuration yet");
        }
        if (AnySAMInputFormat.trustExtensions(this.conf) && (f = SAMFormat.inferFromFilePath(path)) != null) {
            this.formatMap.put(path, f);
            return f;
        }
        try {
            FileSystem fileSystem = path.getFileSystem(this.conf);
            if (!fileSystem.exists(path)) {
                throw new PathNotFoundException(path.toString());
            }
            fmt = SAMFormat.inferFromData((InputStream)fileSystem.open(path));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.formatMap.put(path, fmt);
        return fmt;
    }

    public RecordReader<LongWritable, SAMRecordWritable> createRecordReader(InputSplit split, TaskAttemptContext ctx) throws InterruptedException, IOException {
        SAMFormat fmt;
        Path path;
        if (split instanceof FileSplit) {
            path = ((FileSplit)split).getPath();
        } else if (split instanceof FileVirtualSplit) {
            path = ((FileVirtualSplit)split).getPath();
        } else {
            throw new IllegalArgumentException("split '" + split + "' has unknown type: cannot extract path");
        }
        if (this.conf == null) {
            this.conf = ctx.getConfiguration();
        }
        if ((fmt = this.getFormat(path)) == null) {
            throw new IllegalArgumentException("unknown SAM format, cannot create RecordReader: " + path);
        }
        switch (fmt) {
            case SAM: {
                return this.samIF.createRecordReader(split, ctx);
            }
            case BAM: {
                return this.bamIF.createRecordReader(split, ctx);
            }
            case CRAM: {
                return this.cramIF.createRecordReader(split, ctx);
            }
        }
        assert (false);
        return null;
    }

    public boolean isSplitable(JobContext job, Path path) {
        if (this.conf == null) {
            this.conf = job.getConfiguration();
        }
        try {
            SAMFormat fmt = this.getFormat(path);
            if (fmt == null) {
                return super.isSplitable(job, path);
            }
            switch (fmt) {
                case SAM: {
                    return this.samIF.isSplitable(job, path);
                }
                case BAM: {
                    return this.bamIF.isSplitable(job, path);
                }
                case CRAM: {
                    return this.cramIF.isSplitable(job, path);
                }
            }
            assert (false);
            return false;
        }
        catch (PathNotFoundException e) {
            return super.isSplitable(job, path);
        }
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        if (this.conf == null) {
            this.conf = job.getConfiguration();
        }
        List origSplits = super.getSplits(job);
        ArrayList<InputSplit> bamOrigSplits = new ArrayList<InputSplit>(origSplits.size());
        ArrayList<InputSplit> cramOrigSplits = new ArrayList<InputSplit>(origSplits.size());
        ArrayList<InputSplit> newSplits = new ArrayList<InputSplit>(origSplits.size());
        for (InputSplit iSplit : origSplits) {
            FileSplit split = (FileSplit)iSplit;
            if (SAMFormat.BAM.equals((Object)this.getFormat(split.getPath()))) {
                bamOrigSplits.add((InputSplit)split);
                continue;
            }
            if (SAMFormat.CRAM.equals((Object)this.getFormat(split.getPath()))) {
                cramOrigSplits.add((InputSplit)split);
                continue;
            }
            newSplits.add((InputSplit)split);
        }
        newSplits.addAll(this.bamIF.getSplits(bamOrigSplits, job.getConfiguration()));
        newSplits.addAll(this.cramIF.getSplits(cramOrigSplits, job.getConfiguration()));
        return newSplits;
    }
}

