/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.variant;

import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.broadinstitute.gatk.utils.collections.Pair;

public class VCIterable<SOURCE>
implements Iterable<VariantContext>,
Iterator<VariantContext> {
    final SOURCE source;
    final FeatureCodec<VariantContext, SOURCE> codec;
    final VCFHeader header;

    VCIterable(SOURCE source, FeatureCodec<VariantContext, SOURCE> codec, VCFHeader header) {
        this.source = source;
        this.codec = codec;
        this.header = header;
    }

    public static final <SOURCE> Pair<VCFHeader, VCIterable<SOURCE>> readAllVCs(File file, FeatureCodec<VariantContext, SOURCE> codec) throws IOException {
        SOURCE source = codec.makeSourceFromStream(new FileInputStream(file));
        FeatureCodecHeader header = codec.readHeader(source);
        VCFHeader vcfHeader = (VCFHeader)header.getHeaderValue();
        return new Pair<VCFHeader, VCIterable<SOURCE>>(vcfHeader, new VCIterable<SOURCE>(source, codec, vcfHeader));
    }

    @Override
    public Iterator<VariantContext> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return !this.codec.isDone(this.source);
    }

    @Override
    public VariantContext next() {
        try {
            VariantContext vc = this.codec.decode(this.source);
            return vc == null ? null : vc.fullyDecode(this.header, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
    }
}

