/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.variant;

import java.util.Arrays;
import org.broadinstitute.gatk.utils.Utils;

public final class TandemRepeatFinder {
    private final byte[] bases;
    private final int maxRepeatCount;
    private final int maxUnitLength;

    public TandemRepeatFinder(byte[] bases, int maxUnitLength, int maxRepeatLength) {
        if (bases == null) {
            throw new IllegalArgumentException();
        }
        if (maxRepeatLength < 0) {
            throw new IllegalArgumentException();
        }
        if (maxUnitLength < 0) {
            throw new IllegalArgumentException();
        }
        this.maxRepeatCount = maxRepeatLength;
        this.maxUnitLength = maxUnitLength;
        this.bases = bases;
    }

    protected int numberOfRepeats(int offset, int length) {
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        if (offset < 0 || offset >= this.bases.length) {
            throw new IllegalArgumentException();
        }
        int from = offset;
        int to = offset + length;
        if (to > this.bases.length || to < -1) {
            return 0;
        }
        int increment = length < 0 ? -1 : 1;
        int stop = length < 0 ? -1 : this.bases.length;
        int totalLength = 0;
        while (to != stop && this.bases[to] == this.bases[from]) {
            to += increment;
            from += increment;
            ++totalLength;
        }
        return 1 + totalLength / Math.abs(length);
    }

    public Result findMostRelevantTandemRepeatUnitAt(int offset) {
        int repeatCount;
        int repeatCount2;
        int bestBWRepeatCount = 0;
        int bestBWOffset = offset;
        int bestBWLength = 1;
        for (int str = 1; str <= this.maxUnitLength && (repeatCount2 = this.numberOfRepeats(offset, -str)) != 0; ++str) {
            bestBWRepeatCount = repeatCount2;
            if (bestBWRepeatCount <= 1) continue;
            bestBWOffset = offset - str + 1;
            bestBWLength = str;
            break;
        }
        int bestFWOffset = offset + 1;
        int bestFWLength = 1;
        int bestFWRepeatCount = 0;
        for (int str = 1; str <= this.maxUnitLength && (repeatCount = this.numberOfRepeats(bestFWOffset, str)) != 0; ++str) {
            bestFWRepeatCount = repeatCount;
            if (bestFWRepeatCount <= 1) continue;
            bestFWLength = str;
            break;
        }
        if (bestFWLength == bestBWLength && Utils.equalRange(this.bases, bestFWOffset, this.bases, bestBWOffset, bestFWLength)) {
            return new Result(bestBWOffset, bestBWLength, Math.min(this.maxRepeatCount, bestBWRepeatCount + bestFWRepeatCount));
        }
        int bestFWBackwardRepeatCount = this.numberOfRepeats(bestFWOffset + bestFWLength - 1, -bestFWLength) - 1;
        return new Result(bestFWOffset, bestFWLength, Math.min(this.maxRepeatCount, bestFWRepeatCount + bestFWBackwardRepeatCount));
    }

    public final class Result {
        private final int unitLength;
        private final int unitOffset;
        private final int repeatCount;

        private Result(int unitOffset, int unitLength, int repeatCount) {
            this.unitOffset = unitOffset;
            this.unitLength = unitLength;
            this.repeatCount = repeatCount;
        }

        public byte[] getUnit() {
            return Arrays.copyOfRange(TandemRepeatFinder.this.bases, this.unitOffset, this.unitOffset + this.unitLength);
        }

        public byte[] getBases() {
            return TandemRepeatFinder.this.bases;
        }

        public int getUnitOffset() {
            return this.unitOffset;
        }

        public int getUnitLength() {
            return this.unitLength;
        }

        public int getRepeatCount() {
            return this.repeatCount;
        }
    }
}

