/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.variant;

import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.HashMap;
import java.util.Map;

public class GATKVCFHeaderLines {
    private static Map<String, VCFInfoHeaderLine> infoLines = new HashMap<String, VCFInfoHeaderLine>(60);
    private static Map<String, VCFFormatHeaderLine> formatLines = new HashMap<String, VCFFormatHeaderLine>(25);
    private static Map<String, VCFFilterHeaderLine> filterLines = new HashMap<String, VCFFilterHeaderLine>(2);

    public static VCFInfoHeaderLine getInfoLine(String id) {
        return infoLines.get(id);
    }

    public static VCFFormatHeaderLine getFormatLine(String id) {
        return formatLines.get(id);
    }

    public static VCFFilterHeaderLine getFilterLine(String id) {
        return filterLines.get(id);
    }

    private static void addFormatLine(VCFFormatHeaderLine line) {
        formatLines.put(line.getID(), line);
    }

    private static void addInfoLine(VCFInfoHeaderLine line) {
        infoLines.put(line.getID(), line);
    }

    private static void addFilterLine(VCFFilterHeaderLine line) {
        filterLines.put(line.getID(), line);
    }

    static {
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("LowQual", "Low quality"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("BGL_SET_TO_MONOMORPHIC", "This site was set to monomorphic by Beagle"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("alt_allele_in_normal", "Evidence seen in the normal sample"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("clustered_events", "Clustered events observed in the tumor"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("germline_risk", "Evidence indicates this site is germline, not somatic"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("homologous_mapping_event", "More than three events were observed in the tumor"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("multi_event_alt_allele_in_normal", "Multiple events observed in tumor and normal"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("panel_of_normals", "Seen in at least 2 samples in the panel of normals"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("t_lod_fstar", "Tumor does not meet likelihood threshold"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("str_contraction", "Site filtered due to contraction of short tandem repeat region"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("triallelic_site", "Site filtered because more than two alt alleles pass tumor LOD"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("strand_artifact", "Evidence for alt allele comes from one read direction only"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("clustered_read_position", "Evidence for somatic variant clusters near the ends of reads"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("AB", 1, VCFHeaderLineType.Float, "Allele balance for each het genotype"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("BCS", 4, VCFHeaderLineType.Integer, "Counts of each base by sample"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("MQ0", 1, VCFHeaderLineType.Integer, "Number of Mapping Quality Zero Reads per sample"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("MLPSAC", VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Maximum likelihood expectation (MLE) for the alternate allele count, in the same order as listed, for each individual sample"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("MLPSAF", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Maximum likelihood expectation (MLE) for the alternate allele fraction, in the same order as listed, for each individual sample"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("SAC", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.Integer, "Number of reads on the forward and reverse strand supporting each allele (including reference)"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("SB", 4, VCFHeaderLineType.Integer, "Per-sample component statistics which comprise the Fisher's Exact Test to detect strand bias."));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("MLPSAC", VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Maximum likelihood expectation (MLE) for the alternate allele count, in the same order as listed, for each individual sample"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("MLPSAF", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Maximum likelihood expectation (MLE) for the alternate allele fraction, in the same order as listed, for each individual sample"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("APL", 10, VCFHeaderLineType.Integer, "Phred-scaled genotype likelihoods for all 4 possible bases regardless of whether there is statistical evidence for them. Ordering is always PL for AA AC CC GA GC GG TA TC TG TT."));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("PID", 1, VCFHeaderLineType.String, "Physical phasing ID information, where each unique ID within a given sample (but not across samples) connects records within a phasing group"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("PGT", 1, VCFHeaderLineType.String, "Physical phasing haplotype information, describing how the alternate alleles are phased in relation to one another"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("MIN_DP", 1, VCFHeaderLineType.Integer, "Minimum DP observed within the GVCF block"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("RGQ", 1, VCFHeaderLineType.Integer, "Unconditional reference genotype confidence, encoded as a phred quality -10*log10 p(genotype call is wrong)"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("TP", 1, VCFHeaderLineType.Integer, "Phred score of the genotype combination and phase given that the genotypes are correct"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("HP", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Read-backed phasing haplotype identifiers"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("IDP", 1, VCFHeaderLineType.Float, "Average sample depth across the interval. Sum of the sample specific depth in all loci divided by interval size."));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("LL", 1, VCFHeaderLineType.Integer, "Number of loci for this sample, in this interval with low coverage (below the minimum coverage) but not zero."));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("ZL", 1, VCFHeaderLineType.Integer, "Number of loci for this sample, in this interval with zero coverage."));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("PP", VCFHeaderLineCount.G, VCFHeaderLineType.Integer, "Phred-scaled Posterior Genotype Probabilities"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("JL", 1, VCFHeaderLineType.Integer, "Phred-scaled joint likelihood of the genotype combination (before applying family priors)"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("JP", 1, VCFHeaderLineType.Integer, "Phred-scaled joint posterior probability of the genotype combination (after applying family priors)"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("OG", 1, VCFHeaderLineType.String, "Original Genotype input to Beagle"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("AF", 1, VCFHeaderLineType.Float, "Allele fraction of the event in the tumor"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("ALT_F1R2", 1, VCFHeaderLineType.Integer, "Count of reads in F1R2 pair orientation supporting the alternate allele"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("ALT_F2R1", 1, VCFHeaderLineType.Integer, "Count of reads in F2R1 pair orientation supporting the alternate allele"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("REF_F1R2", 1, VCFHeaderLineType.Integer, "Count of reads in F1R2 pair orientation supporting the reference allele"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("REF_F2R1", 1, VCFHeaderLineType.Integer, "Count of reads in F2R1 pair orientation supporting the reference allele"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("FOXOG", 1, VCFHeaderLineType.Float, "Fraction of alt reads indicating OxoG error"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MLEAC", VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Maximum likelihood expectation (MLE) for the allele counts (not necessarily the same as the AC), for each ALT allele, in the same order as listed"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MLEAF", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Maximum likelihood expectation (MLE) for the allele frequency (not necessarily the same as the AF), for each ALT allele, in the same order as listed"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("DS", 0, VCFHeaderLineType.Flag, "Were any of the samples downsampled?"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("ABHet", 1, VCFHeaderLineType.Float, "Allele Balance for heterozygous calls (ref/(ref+alt))"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("ABHom", 1, VCFHeaderLineType.Float, "Allele Balance for homozygous calls (A/(A+O)) where A is the allele (ref or alt) and O is anything other"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("OND", 1, VCFHeaderLineType.Float, "Overall non-diploid ratio (alleles/(alleles+non-alleles))"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("BaseCounts", 4, VCFHeaderLineType.Integer, "Counts of each base"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("LowMQ", 3, VCFHeaderLineType.Float, "3-tuple: <fraction of reads with MQ=0>,<fraction of reads with MQ<=10>,<total number of reads>"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("PercentNBase", 1, VCFHeaderLineType.Float, "Percentage of N bases in the pileup"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("BaseQRankSum", 1, VCFHeaderLineType.Float, "Z-score from Wilcoxon rank sum test of Alt Vs. Ref base qualities"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_BaseQRankSum", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "allele specific Z-score from Wilcoxon rank sum test of each Alt Vs. Ref base qualities"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_RAW_BaseQRankSum", 1, VCFHeaderLineType.String, "raw data for allele specific rank sum test of base qualities"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_MateMQRankSum", 1, VCFHeaderLineType.Float, "allele specific Z-score from Wilcoxon rank sum test of mate mapping qualities"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_RAW_MateMQRankSum", 1, VCFHeaderLineType.String, "raw data for allele specific rank sum tes of mate mapping qualities"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("ClippingRankSum", 1, VCFHeaderLineType.Float, "Z-score From Wilcoxon rank sum test of Alt vs. Ref number of hard clipped bases"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_FilterStatus", VCFHeaderLineCount.A, VCFHeaderLineType.String, "Filter status for each allele, as assessed by ApplyRecalibration. Note that the VCF filter field will reflect the most lenient/sensitive status across all alleles."));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("FS", 1, VCFHeaderLineType.Float, "Phred-scaled p-value using Fisher's exact test to detect strand bias"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_FS", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "allele specific phred-scaled p-value using Fisher's exact test to detect strand bias of each alt allele"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_SB_TABLE", 1, VCFHeaderLineType.String, "Allele-specific forward/reverse read counts for strand bias tests"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("GC", 1, VCFHeaderLineType.Float, "GC content around the variant (see docs for window size details)"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("NCC", 1, VCFHeaderLineType.Integer, "Number of no-called samples"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("GQ_MEAN", 1, VCFHeaderLineType.Float, "Mean of all GQ values"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("GQ_STDDEV", 1, VCFHeaderLineType.Float, "Standard deviation of all GQ values"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("HaplotypeScore", 1, VCFHeaderLineType.Float, "Consistency of the site with at most two segregating haplotypes"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("HW", 1, VCFHeaderLineType.Float, "Phred-scaled p-value for Hardy-Weinberg violation"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("HRun", 1, VCFHeaderLineType.Integer, "Largest Contiguous Homopolymer Run of Variant Allele In Either Direction"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("InbreedingCoeff", 1, VCFHeaderLineType.Float, "Inbreeding coefficient as estimated from the genotype likelihoods per-sample when compared against the Hardy-Weinberg expectation"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_InbreedingCoeff", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Allele-specific inbreeding coefficient as estimated from the genotype likelihoods per-sample when compared against the Hardy-Weinberg expectation"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("ExcessHet", 1, VCFHeaderLineType.Float, "Phred-scaled p-value for exact test of excess heterozygosity"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_InbreedingCoeff", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "allele specific heterozygosity as estimated from the genotype likelihoods per-sample when compared against the Hardy-Weinberg expectation; relate to inbreeding coefficient"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("LikelihoodRankSum", 1, VCFHeaderLineType.Float, "Z-score from Wilcoxon rank sum test of Alt Vs. Ref haplotype likelihoods"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MQRankSum", 1, VCFHeaderLineType.Float, "Z-score From Wilcoxon rank sum test of Alt vs. Ref read mapping qualities"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_MQRankSum", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "allele specific Z-score From Wilcoxon rank sum test of each Alt vs. Ref read mapping qualities"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("RAW_MQ", 1, VCFHeaderLineType.Float, "Raw data for RMS Mapping Quality"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_RAW_MQ", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Allele-specfic raw data for RMS Mapping Quality"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_MQ", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Allele-specific RMS Mapping Quality"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("RAW_MQRankSum", 1, VCFHeaderLineType.Float, "Raw data for Mapping Quality Rank Sum"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_RAW_MQRankSum", 1, VCFHeaderLineType.String, "Allele-specific raw data for Mapping Quality Rank Sum"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_MQRankSum", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Allele-specific Mapping Quality Rank Sum"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("FractionInformativeReads", 1, VCFHeaderLineType.Float, "The fraction of informative reads out of the total reads"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_RAW_InsertSizeRankSum", 1, VCFHeaderLineType.String, "Allele-specific raw data for Insert Size Rank Sum"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_InsertSizeRankSum", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Allele-specific Insert Size Rank Sum"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MVLR", 1, VCFHeaderLineType.Float, "Mendelian violation likelihood ratio: L[MV] - L[No MV]"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("hiConfDeNovo", 1, VCFHeaderLineType.String, "High confidence possible de novo mutation (GQ >= 20 for all trio members)=[comma-delimited list of child samples]"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("loConfDeNovo", 1, VCFHeaderLineType.String, "Low confidence possible de novo mutation (GQ >= 10 for child, GQ > 0 for parents)=[comma-delimited list of child samples]"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("QD", 1, VCFHeaderLineType.Float, "Variant Confidence/Quality by Depth"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_QD", 1, VCFHeaderLineType.Float, "Allele-specific Variant Confidence/Quality by Depth"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_QUAL", 1, VCFHeaderLineType.Float, "Allele-specific Variant Qual Score"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("ReadPosRankSum", 1, VCFHeaderLineType.Float, "Z-score from Wilcoxon rank sum test of Alt vs. Ref read position bias"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_ReadPosRankSum", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "allele specific Z-score from Wilcoxon rank sum test of each Alt vs. Ref read position bias"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_RAW_ReadPosRankSum", 1, VCFHeaderLineType.String, "allele specific raw data for rank sum test of read position bias"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("Samples", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "List of polymorphic samples"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("Dels", 1, VCFHeaderLineType.Float, "Fraction of Reads Containing Spanning Deletions"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("SOR", 1, VCFHeaderLineType.Float, "Symmetric Odds Ratio of 2x2 contingency table to detect strand bias"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_SOR", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Allele specific strand Odds Ratio of 2x|Alts| contingency table to detect allele specific strand bias"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("STR", 0, VCFHeaderLineType.Flag, "Variant is a short tandem repeat"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("RU", 1, VCFHeaderLineType.String, "Tandem repeat unit (bases)"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("RPA", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.Integer, "Number of times tandem repeat unit is repeated, for each allele (including reference)"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("TDT", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Test statistic from Wittkowski transmission disequilibrium test."));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("VariantType", 1, VCFHeaderLineType.String, "Variant type description"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("NDA", 1, VCFHeaderLineType.Integer, "Number of alternate alleles discovered (but not necessarily genotyped) at this site"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("REFDEPTH", 1, VCFHeaderLineType.Integer, "Total reference sample depth"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AC_Orig", VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Original AC"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AF_Orig", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Original AF"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AN_Orig", 1, VCFHeaderLineType.Integer, "Original AN"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("DP_Orig", 1, VCFHeaderLineType.Integer, "Original DP"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("OriginalChr", 1, VCFHeaderLineType.String, "Original contig name for the record"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("OriginalStart", 1, VCFHeaderLineType.Integer, "Original start position for the record"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("VQSLOD", 1, VCFHeaderLineType.Float, "Log odds of being a true variant versus being false under the trained gaussian mixture model"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_VQSLOD", VCFHeaderLineCount.A, VCFHeaderLineType.String, "For each alt allele, the log odds of being a true variant versus being false under the trained gaussian mixture model"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("culprit", 1, VCFHeaderLineType.String, "The annotation which was the worst performing in the Gaussian mixture model, likely the reason why the variant was filtered out"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_culprit", VCFHeaderLineCount.A, VCFHeaderLineType.String, "For each alt allele, the annotation which was the worst performing in the Gaussian mixture model, likely the reason why the variant was filtered out"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("POSITIVE_TRAIN_SITE", 1, VCFHeaderLineType.Flag, "This variant was used to build the positive training set of good variants"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("NEGATIVE_TRAIN_SITE", 1, VCFHeaderLineType.Flag, "This variant was used to build the negative training set of bad variants"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("PhasingInconsistent", 0, VCFHeaderLineType.Flag, "Are the reads significantly haplotype-inconsistent?"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("callStatus", 1, VCFHeaderLineType.String, "Value from the validation VCF"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("IDP", 1, VCFHeaderLineType.Float, "Average depth across the interval. Sum of the depth in a loci divided by interval size."));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("IGC", 1, VCFHeaderLineType.Float, "GC Content of the interval"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("PG", VCFHeaderLineCount.G, VCFHeaderLineType.Integer, "Genotype Likelihood Prior"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("R2", 1, VCFHeaderLineType.Float, "r2 Value reported by Beagle on each site"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("NumGenotypesChanged", 1, VCFHeaderLineType.Integer, "The number of genotypes changed by Beagle"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("OriginalAltAllele", 1, VCFHeaderLineType.String, "The original alt allele for a site set to monomorphic by Beagle"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("ACH", 1, VCFHeaderLineType.Integer, "Allele Count from Comparison ROD at this site"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AFH", 1, VCFHeaderLineType.Integer, "Allele Frequency from Comparison ROD at this site"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("ANH", 1, VCFHeaderLineType.Float, "Allele Number from Comparison ROD at this site"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("ECNT", 1, VCFHeaderLineType.String, "Number of events in this haplotype"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MAX_ED", 1, VCFHeaderLineType.Integer, "Maximum distance between events in this active region"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MIN_ED", 1, VCFHeaderLineType.Integer, "Minimum distance between events in this active region"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("HCNT", 1, VCFHeaderLineType.String, "Number of haplotypes that support this variant"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("NLOD", 1, VCFHeaderLineType.String, "Normal LOD score"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("PON", 1, VCFHeaderLineType.String, "Count from Panel of Normals"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("TLOD", 1, VCFHeaderLineType.String, "Tumor LOD score"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("TLOD_FWD", 1, VCFHeaderLineType.Float, "TLOD from forward reads only"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("TLOD_REV", 1, VCFHeaderLineType.Float, "TLOD from reverse reads only"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("TUMOR_SB_POWER_FWD", 1, VCFHeaderLineType.Float, "Strand bias power for forward reads"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("TUMOR_SB_POWER_REV", 1, VCFHeaderLineType.Float, "Stand bias power for reverse reads"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MEDIAN_LEFT_OFFSET", 1, VCFHeaderLineType.Float, "Median of the number of bases between the left end of the tumor read and the variant"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MEDIAN_RIGHT_OFFSET", 1, VCFHeaderLineType.Float, "Median of the number of bases between the variant and the right end of the tumor read"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MAD_LEFT_OFFSET", 1, VCFHeaderLineType.Float, "Median absolute deviation of medians of the number of bases between the left end of the tumor read and the variant"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MAD_RIGHT_OFFSET", 1, VCFHeaderLineType.Float, "Median absolute deviation of medians of the number of bases between the variant and the right end of the tumor read"));
    }
}

